/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internal.collection.queues;

import monix.execution.ChannelType;
import monix.execution.ChannelType$SingleConsumer$;
import monix.execution.ChannelType$SingleProducer$;
import monix.execution.internal.atomic.UnsafeAccess;
import monix.execution.internal.collection.LowLevelConcurrentQueue;
import monix.execution.internal.collection.queues.FromCircularQueue$;
import monix.execution.internal.collection.queues.QueueDrain;
import monix.execution.internal.jctools.queues.MessagePassingQueue;
import scala.collection.mutable.Buffer;
import sun.misc.Unsafe;

public abstract class FromCircularQueue<A>
implements LowLevelConcurrentQueue<A> {
    private final MessagePassingQueue<A> queue;

    public static <A> FromCircularQueue<A> apply(MessagePassingQueue<A> messagePassingQueue, ChannelType channelType) {
        return FromCircularQueue$.MODULE$.apply(messagePassingQueue, channelType);
    }

    public FromCircularQueue(MessagePassingQueue<A> queue) {
        this.queue = queue;
    }

    @Override
    public abstract void fenceOffer();

    @Override
    public abstract void fencePoll();

    @Override
    public final boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public final int offer(A elem) {
        return this.queue.offer(elem) ? 0 : 1;
    }

    @Override
    public final A poll() {
        return (A)this.queue.poll();
    }

    @Override
    public final void clear() {
        this.queue.clear();
    }

    @Override
    public final int drainToBuffer(Buffer<A> buffer, int limit) {
        QueueDrain<A> consume = new QueueDrain<A>(buffer);
        this.queue.drain(consume, limit);
        return consume.count();
    }

    private static final class Java7<A>
    extends FromCircularQueue<A> {
        private final ChannelType ct;

        public Java7(MessagePassingQueue<A> queue, ChannelType ct) {
            this.ct = ct;
            super(queue);
        }

        @Override
        public void fenceOffer() {
            ChannelType.ProducerSide producerSide = this.ct.producerType();
            ChannelType$SingleProducer$ channelType$SingleProducer$ = ChannelType$SingleProducer$.MODULE$;
            if (!(producerSide != null ? !producerSide.equals(channelType$SingleProducer$) : channelType$SingleProducer$ != null)) {
                this.raise();
            }
        }

        @Override
        public void fencePoll() {
            ChannelType.ConsumerSide consumerSide = this.ct.consumerType();
            ChannelType$SingleConsumer$ channelType$SingleConsumer$ = ChannelType$SingleConsumer$.MODULE$;
            if (!(consumerSide != null ? !consumerSide.equals(channelType$SingleConsumer$) : channelType$SingleConsumer$ != null)) {
                this.raise();
            }
        }

        private void raise() {
            throw new IllegalAccessException("Unsafe.fullFence not supported on this platform! (please report bug)");
        }
    }

    private static final class Java8MPSC<A>
    extends FromCircularQueue<A> {
        private final Unsafe UNSAFE = (Unsafe)UnsafeAccess.getInstance();

        public Java8MPSC(MessagePassingQueue<A> queue) {
            super(queue);
        }

        @Override
        public void fenceOffer() {
        }

        @Override
        public void fencePoll() {
            this.UNSAFE.fullFence();
        }
    }

    private static final class Java8SPMC<A>
    extends FromCircularQueue<A> {
        private final Unsafe UNSAFE = (Unsafe)UnsafeAccess.getInstance();

        public Java8SPMC(MessagePassingQueue<A> queue) {
            super(queue);
        }

        @Override
        public void fenceOffer() {
            this.UNSAFE.fullFence();
        }

        @Override
        public void fencePoll() {
        }
    }

    private static final class Java8SPSC<A>
    extends FromCircularQueue<A> {
        private final Unsafe UNSAFE = (Unsafe)UnsafeAccess.getInstance();

        public Java8SPSC(MessagePassingQueue<A> queue) {
            super(queue);
        }

        @Override
        public void fenceOffer() {
            this.UNSAFE.fullFence();
        }

        @Override
        public void fencePoll() {
            this.UNSAFE.fullFence();
        }
    }

    private static final class MPMC<A>
    extends FromCircularQueue<A> {
        public MPMC(MessagePassingQueue<A> queue) {
            super(queue);
        }

        @Override
        public void fenceOffer() {
        }

        @Override
        public void fencePoll() {
        }
    }
}

