/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.bulk.ClientBulkWriteOptions;
import com.mongodb.client.model.bulk.ClientBulkWriteResult;
import com.mongodb.client.model.bulk.ClientNamespacedWriteModel;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListDatabasesPublisher;
import com.mongodb.reactivestreams.client.MongoCluster;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.internal.ChangeStreamPublisherImpl;
import com.mongodb.reactivestreams.client.internal.ClientSessionHelper;
import com.mongodb.reactivestreams.client.internal.ListDatabasesPublisherImpl;
import com.mongodb.reactivestreams.client.internal.MongoDatabaseImpl;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import com.mongodb.reactivestreams.client.internal.OperationExecutor;
import com.mongodb.reactivestreams.client.internal.crypt.Crypt;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class MongoClusterImpl
implements MongoCluster {
    private final Cluster cluster;
    private final Crypt crypt;
    private final OperationExecutor operationExecutor;
    private final ServerSessionPool serverSessionPool;
    private final ClientSessionHelper clientSessionHelper;
    private final MongoOperationPublisher<Document> mongoOperationPublisher;

    MongoClusterImpl(Cluster cluster, @Nullable Crypt crypt, OperationExecutor operationExecutor, ServerSessionPool serverSessionPool, ClientSessionHelper clientSessionHelper, MongoOperationPublisher<Document> mongoOperationPublisher) {
        this.cluster = cluster;
        this.crypt = crypt;
        this.operationExecutor = operationExecutor;
        this.serverSessionPool = serverSessionPool;
        this.clientSessionHelper = clientSessionHelper;
        this.mongoOperationPublisher = mongoOperationPublisher;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.mongoOperationPublisher.getCodecRegistry();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.mongoOperationPublisher.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.mongoOperationPublisher.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.mongoOperationPublisher.getReadConcern();
    }

    @Override
    public Long getTimeout(TimeUnit timeUnit) {
        Long timeoutMS = this.mongoOperationPublisher.getTimeoutMS();
        return timeoutMS != null ? Long.valueOf(TimeUnit.MILLISECONDS.convert(timeoutMS, timeUnit)) : null;
    }

    @Override
    public MongoCluster withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoClusterImpl(this.cluster, this.crypt, this.operationExecutor, this.serverSessionPool, this.clientSessionHelper, this.mongoOperationPublisher.withCodecRegistry(codecRegistry));
    }

    @Override
    public MongoCluster withReadPreference(ReadPreference readPreference) {
        return new MongoClusterImpl(this.cluster, this.crypt, this.operationExecutor, this.serverSessionPool, this.clientSessionHelper, this.mongoOperationPublisher.withReadPreference(readPreference));
    }

    @Override
    public MongoCluster withWriteConcern(WriteConcern writeConcern) {
        return new MongoClusterImpl(this.cluster, this.crypt, this.operationExecutor, this.serverSessionPool, this.clientSessionHelper, this.mongoOperationPublisher.withWriteConcern(writeConcern));
    }

    @Override
    public MongoCluster withReadConcern(ReadConcern readConcern) {
        return new MongoClusterImpl(this.cluster, this.crypt, this.operationExecutor, this.serverSessionPool, this.clientSessionHelper, this.mongoOperationPublisher.withReadConcern(readConcern));
    }

    @Override
    public MongoCluster withTimeout(long timeout, TimeUnit timeUnit) {
        return new MongoClusterImpl(this.cluster, this.crypt, this.operationExecutor, this.serverSessionPool, this.clientSessionHelper, this.mongoOperationPublisher.withTimeout(timeout, timeUnit));
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    @Nullable
    public Crypt getCrypt() {
        return this.crypt;
    }

    public ClientSessionHelper getClientSessionHelper() {
        return this.clientSessionHelper;
    }

    public ServerSessionPool getServerSessionPool() {
        return this.serverSessionPool;
    }

    public MongoOperationPublisher<Document> getMongoOperationPublisher() {
        return this.mongoOperationPublisher;
    }

    public TimeoutSettings getTimeoutSettings() {
        return this.mongoOperationPublisher.getTimeoutSettings();
    }

    @Override
    public Publisher<ClientSession> startSession() {
        return this.startSession(ClientSessionOptions.builder().build());
    }

    @Override
    public Publisher<ClientSession> startSession(ClientSessionOptions options) {
        Assertions.notNull((String)"options", (Object)options);
        return Mono.fromCallable(() -> this.clientSessionHelper.createClientSession(options, this.operationExecutor));
    }

    @Override
    public MongoDatabase getDatabase(String name) {
        return new MongoDatabaseImpl(this.mongoOperationPublisher.withDatabase(name));
    }

    @Override
    public Publisher<String> listDatabaseNames() {
        return Flux.from(this.listDatabases().nameOnly(true)).map(d -> d.getString((Object)"name"));
    }

    @Override
    public Publisher<String> listDatabaseNames(ClientSession clientSession) {
        return Flux.from(this.listDatabases(clientSession).nameOnly(true)).map(d -> d.getString((Object)"name"));
    }

    @Override
    public ListDatabasesPublisher<Document> listDatabases() {
        return this.listDatabases((Class<T>)Document.class);
    }

    public <T> ListDatabasesPublisher<T> listDatabases(Class<T> clazz) {
        return new ListDatabasesPublisherImpl<T>(null, this.mongoOperationPublisher.withDocumentClass(clazz));
    }

    @Override
    public ListDatabasesPublisher<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, (Class<T>)Document.class);
    }

    public <T> ListDatabasesPublisher<T> listDatabases(ClientSession clientSession, Class<T> clazz) {
        return new ListDatabasesPublisherImpl<T>((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), this.mongoOperationPublisher.withDocumentClass(clazz));
    }

    @Override
    public ChangeStreamPublisher<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    public <T> ChangeStreamPublisher<T> watch(Class<T> resultClass) {
        return this.watch((List<? extends Bson>)Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, (Class<T>)Document.class);
    }

    public <T> ChangeStreamPublisher<T> watch(List<? extends Bson> pipeline, Class<T> resultClass) {
        return new ChangeStreamPublisherImpl<T>(null, this.mongoOperationPublisher.withDatabase("admin"), resultClass, pipeline, ChangeStreamLevel.CLIENT);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, (List<? extends Bson>)Collections.emptyList(), (Class<T>)Document.class);
    }

    public <T> ChangeStreamPublisher<T> watch(ClientSession clientSession, Class<T> resultClass) {
        return this.watch(clientSession, (List<? extends Bson>)Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, (Class<T>)Document.class);
    }

    public <T> ChangeStreamPublisher<T> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<T> resultClass) {
        return new ChangeStreamPublisherImpl<T>((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), this.mongoOperationPublisher.withDatabase("admin"), resultClass, pipeline, ChangeStreamLevel.CLIENT);
    }

    @Override
    public Publisher<ClientBulkWriteResult> bulkWrite(List<? extends ClientNamespacedWriteModel> clientWriteModels) {
        Assertions.notNull((String)"clientWriteModels", clientWriteModels);
        Assertions.isTrueArgument((String)"`clientWriteModels` must not be empty", (!clientWriteModels.isEmpty() ? 1 : 0) != 0);
        return this.mongoOperationPublisher.clientBulkWrite(null, clientWriteModels, null);
    }

    @Override
    public Publisher<ClientBulkWriteResult> bulkWrite(List<? extends ClientNamespacedWriteModel> clientWriteModels, ClientBulkWriteOptions options) {
        Assertions.notNull((String)"clientWriteModels", clientWriteModels);
        Assertions.isTrueArgument((String)"`clientWriteModels` must not be empty", (!clientWriteModels.isEmpty() ? 1 : 0) != 0);
        Assertions.notNull((String)"options", (Object)options);
        return this.mongoOperationPublisher.clientBulkWrite(null, clientWriteModels, options);
    }

    @Override
    public Publisher<ClientBulkWriteResult> bulkWrite(ClientSession clientSession, List<? extends ClientNamespacedWriteModel> clientWriteModels) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        Assertions.notNull((String)"clientWriteModels", clientWriteModels);
        Assertions.isTrueArgument((String)"`clientWriteModels` must not be empty", (!clientWriteModels.isEmpty() ? 1 : 0) != 0);
        return this.mongoOperationPublisher.clientBulkWrite(clientSession, clientWriteModels, null);
    }

    @Override
    public Publisher<ClientBulkWriteResult> bulkWrite(ClientSession clientSession, List<? extends ClientNamespacedWriteModel> clientWriteModels, ClientBulkWriteOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        Assertions.notNull((String)"clientWriteModels", clientWriteModels);
        Assertions.isTrueArgument((String)"`clientWriteModels` must not be empty", (!clientWriteModels.isEmpty() ? 1 : 0) != 0);
        Assertions.notNull((String)"options", (Object)options);
        return this.mongoOperationPublisher.clientBulkWrite(clientSession, clientWriteModels, options);
    }
}

