/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.util.concurrent.TimeUnit;
import reactor.core.publisher.Mono;

public final class TimeoutHelper {
    private static final String DEFAULT_TIMEOUT_MESSAGE = "Operation exceeded the timeout limit.";

    private TimeoutHelper() {
    }

    public static <T> MongoCollection<T> collectionWithTimeout(MongoCollection<T> collection, @Nullable Timeout timeout) {
        return TimeoutHelper.collectionWithTimeout(collection, timeout, DEFAULT_TIMEOUT_MESSAGE);
    }

    public static <T> MongoCollection<T> collectionWithTimeout(MongoCollection<T> collection, @Nullable Timeout timeout, String message) {
        if (timeout != null) {
            return (MongoCollection)timeout.call(TimeUnit.MILLISECONDS, () -> collection.withTimeout(0L, TimeUnit.MILLISECONDS), ms -> collection.withTimeout(ms, TimeUnit.MILLISECONDS), () -> (MongoCollection)TimeoutContext.throwMongoTimeoutException((String)message));
        }
        return collection;
    }

    public static <T> Mono<MongoCollection<T>> collectionWithTimeoutMono(MongoCollection<T> collection, @Nullable Timeout timeout) {
        try {
            return Mono.just(TimeoutHelper.collectionWithTimeout(collection, timeout));
        }
        catch (MongoOperationTimeoutException e) {
            return Mono.error((Throwable)e);
        }
    }

    public static <T> Mono<MongoCollection<T>> collectionWithTimeoutDeferred(MongoCollection<T> collection, @Nullable Timeout timeout) {
        return Mono.defer(() -> TimeoutHelper.collectionWithTimeoutMono(collection, timeout));
    }

    public static MongoDatabase databaseWithTimeout(MongoDatabase database, @Nullable Timeout timeout) {
        return TimeoutHelper.databaseWithTimeout(database, DEFAULT_TIMEOUT_MESSAGE, timeout);
    }

    public static MongoDatabase databaseWithTimeout(MongoDatabase database, String message, @Nullable Timeout timeout) {
        if (timeout != null) {
            return (MongoDatabase)timeout.call(TimeUnit.MILLISECONDS, () -> database.withTimeout(0L, TimeUnit.MILLISECONDS), ms -> database.withTimeout(ms, TimeUnit.MILLISECONDS), () -> (MongoDatabase)TimeoutContext.throwMongoTimeoutException((String)message));
        }
        return database;
    }

    private static Mono<MongoDatabase> databaseWithTimeoutMono(MongoDatabase database, String message, @Nullable Timeout timeout) {
        try {
            return Mono.just((Object)TimeoutHelper.databaseWithTimeout(database, message, timeout));
        }
        catch (MongoOperationTimeoutException e) {
            return Mono.error((Throwable)e);
        }
    }

    public static Mono<MongoDatabase> databaseWithTimeoutDeferred(MongoDatabase database, @Nullable Timeout timeout) {
        return TimeoutHelper.databaseWithTimeoutDeferred(database, DEFAULT_TIMEOUT_MESSAGE, timeout);
    }

    public static Mono<MongoDatabase> databaseWithTimeoutDeferred(MongoDatabase database, String message, @Nullable Timeout timeout) {
        return Mono.defer(() -> TimeoutHelper.databaseWithTimeoutMono(database, message, timeout));
    }
}

