/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import cats.Show;
import cats.Show$;
import cats.kernel.Eq;
import cats.package$;
import io.circe.Json;
import io.circe.Json$JArray$;
import io.circe.Json$JBoolean$;
import io.circe.Json$JNull$;
import io.circe.Json$JNumber$;
import io.circe.Json$JObject$;
import io.circe.Json$JString$;
import io.circe.JsonBigDecimal$;
import io.circe.JsonBiggerDecimal$;
import io.circe.JsonDouble$;
import io.circe.JsonFloat$;
import io.circe.JsonNumber;
import io.circe.JsonNumber$;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import io.circe.numbers.BiggerDecimal$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.deriving.Mirror;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Json$
implements Mirror.Sum,
Serializable {
    public static final Json$JNull$ JNull;
    public static final Json$JBoolean$ JBoolean;
    public static final Json$JNumber$ JNumber;
    public static final Json$JString$ JString;
    public static final Json$JArray$ JArray;
    public static final Json$JObject$ JObject;
    private static final Json Null;
    private static final Json True;
    private static final Json False;
    private static final Json EmptyArray;
    private static final Json EmptyString;
    private static final Eq eqJson;
    private static final Show showJson;
    public static final Json$ MODULE$;

    private Json$() {
    }

    static {
        MODULE$ = new Json$();
        Null = Json$JNull$.MODULE$;
        True = Json$JBoolean$.MODULE$.apply(true);
        False = Json$JBoolean$.MODULE$.apply(false);
        EmptyArray = Json$JArray$.MODULE$.apply((Vector<Json>)scala.package$.MODULE$.Vector().empty());
        EmptyString = Json$JString$.MODULE$.apply("");
        eqJson = package$.MODULE$.Eq().instance((Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Json json = (Json)tuple2._1();
                Json json2 = (Json)tuple2._2();
                if (json instanceof Json.JObject) {
                    JsonObject jsonObject;
                    Json.JObject jObject = Json$JObject$.MODULE$.unapply((Json.JObject)json);
                    JsonObject a = jsonObject = jObject._1();
                    if (json2 instanceof Json.JObject) {
                        JsonObject jsonObject2;
                        Json.JObject jObject2 = Json$JObject$.MODULE$.unapply((Json.JObject)json2);
                        JsonObject b = jsonObject2 = jObject2._1();
                        return JsonObject$.MODULE$.eqJsonObject().eqv((Object)a, (Object)b);
                    }
                }
                if (json instanceof Json.JString) {
                    String string;
                    Json.JString jString = Json$JString$.MODULE$.unapply((Json.JString)json);
                    String a = string = jString._1();
                    if (json2 instanceof Json.JString) {
                        String string2;
                        Json.JString jString2 = Json$JString$.MODULE$.unapply((Json.JString)json2);
                        String b = string2 = jString2._1();
                        String string3 = a;
                        String string4 = b;
                        return !(string3 != null ? !string3.equals(string4) : string4 != null);
                    }
                }
                if (json instanceof Json.JNumber) {
                    JsonNumber jsonNumber;
                    Json.JNumber jNumber = Json$JNumber$.MODULE$.unapply((Json.JNumber)json);
                    JsonNumber a = jsonNumber = jNumber._1();
                    if (json2 instanceof Json.JNumber) {
                        JsonNumber jsonNumber2;
                        Json.JNumber jNumber2 = Json$JNumber$.MODULE$.unapply((Json.JNumber)json2);
                        JsonNumber b = jsonNumber2 = jNumber2._1();
                        return JsonNumber$.MODULE$.eqJsonNumber().eqv((Object)a, (Object)b);
                    }
                }
                if (json instanceof Json.JBoolean) {
                    boolean bl;
                    Json.JBoolean jBoolean = Json$JBoolean$.MODULE$.unapply((Json.JBoolean)json);
                    boolean a = bl = jBoolean._1();
                    if (json2 instanceof Json.JBoolean) {
                        Json.JBoolean jBoolean2 = Json$JBoolean$.MODULE$.unapply((Json.JBoolean)json2);
                        boolean bl2 = jBoolean2._1();
                        boolean b = bl2;
                        return a == b;
                    }
                }
                if (json instanceof Json.JArray) {
                    Vector<Json> vector;
                    Json.JArray jArray = Json$JArray$.MODULE$.unapply((Json.JArray)json);
                    Vector<Json> a = vector = jArray._1();
                    if (json2 instanceof Json.JArray) {
                        Vector<Json> vector2;
                        Json.JArray jArray2 = Json$JArray$.MODULE$.unapply((Json.JArray)json2);
                        Vector<Json> b = vector2 = jArray2._1();
                        return this.arrayEq(a, b);
                    }
                }
                Json x = json;
                Json y = json2;
                return x.isNull() && y.isNull();
            }
            throw new MatchError((Object)tuple2);
        });
        showJson = Show$.MODULE$.fromToString();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Json$.class);
    }

    public final Json Null() {
        return Null;
    }

    public final Json True() {
        return True;
    }

    public final Json False() {
        return False;
    }

    public final Json obj(Seq<Tuple2<String, Json>> fields) {
        return this.fromFields((Iterable<Tuple2<String, Json>>)fields);
    }

    public final Json arr(Seq<Json> values) {
        return this.fromValues((Iterable<Json>)values);
    }

    public final Json fromFields(Iterable<Tuple2<String, Json>> fields) {
        return Json$JObject$.MODULE$.apply(JsonObject$.MODULE$.fromIterable(fields));
    }

    public final Json fromValues(Iterable<Json> values) {
        if (values.isEmpty()) {
            return EmptyArray;
        }
        return Json$JArray$.MODULE$.apply((Vector<Json>)values.toVector());
    }

    public final Json fromJsonObject(JsonObject value) {
        return Json$JObject$.MODULE$.apply(value);
    }

    public final Json fromJsonNumber(JsonNumber value) {
        return Json$JNumber$.MODULE$.apply(value);
    }

    public final Json fromString(String value) {
        if (value.isEmpty()) {
            return EmptyString;
        }
        return Json$JString$.MODULE$.apply(value);
    }

    public final Json fromStringOrNull(Option<String> value2) {
        return (Json)value2.fold(Json$::fromStringOrNull$$anonfun$1, (Function1 & Serializable)value -> MODULE$.fromString((String)value));
    }

    public final Json fromBoolean(boolean value) {
        if (value) {
            return this.True();
        }
        return this.False();
    }

    public final Json fromBooleanOrNull(Option<Object> value2) {
        return (Json)value2.fold(Json$::fromBooleanOrNull$$anonfun$1, (Function1 & Serializable)value -> Json$.MODULE$.fromBoolean(BoxesRunTime.unboxToBoolean((Object)value)));
    }

    public final Json fromInt(int value) {
        return JsonNumber$.MODULE$.fromLong(value);
    }

    public final Json fromIntOrNull(Option<Object> value2) {
        return (Json)value2.fold(Json$::fromIntOrNull$$anonfun$1, (Function1 & Serializable)value -> Json$.MODULE$.fromInt(BoxesRunTime.unboxToInt((Object)value)));
    }

    public final Json fromLong(long value) {
        return JsonNumber$.MODULE$.fromLong(value);
    }

    public final Json fromLongOrNull(Option<Object> value2) {
        return (Json)value2.fold(Json$::fromLongOrNull$$anonfun$1, (Function1 & Serializable)value -> Json$.MODULE$.fromLong(BoxesRunTime.unboxToLong((Object)value)));
    }

    public final Option<Json> fromDouble(double value) {
        if (this.isReal(value)) {
            return Some$.MODULE$.apply((Object)Json$JNumber$.MODULE$.apply(JsonDouble$.MODULE$.apply(value)));
        }
        return None$.MODULE$;
    }

    public final Option<Json> fromFloat(float value) {
        if (this.isReal(value)) {
            return Some$.MODULE$.apply((Object)Json$JNumber$.MODULE$.apply(JsonFloat$.MODULE$.apply(value)));
        }
        return None$.MODULE$;
    }

    public final Json fromDoubleOrNull(Option<Object> value2) {
        return (Json)value2.fold(Json$::fromDoubleOrNull$$anonfun$1, (Function1 & Serializable)value -> Json$.MODULE$.fromDoubleOrNull(BoxesRunTime.unboxToDouble((Object)value)));
    }

    public final Json fromDoubleOrNull(double value) {
        if (this.isReal(value)) {
            return Json$JNumber$.MODULE$.apply(JsonDouble$.MODULE$.apply(value));
        }
        return this.Null();
    }

    public final Json fromFloatOrNull(float value) {
        if (this.isReal(value)) {
            return Json$JNumber$.MODULE$.apply(JsonFloat$.MODULE$.apply(value));
        }
        return this.Null();
    }

    public final Json fromFloatOrNull(Option<Object> value2) {
        return (Json)value2.fold(Json$::fromFloatOrNull$$anonfun$1, (Function1 & Serializable)value -> Json$.MODULE$.fromFloatOrNull(BoxesRunTime.unboxToFloat((Object)value)));
    }

    public final Json fromDoubleOrString(double value) {
        if (this.isReal(value)) {
            return Json$JNumber$.MODULE$.apply(JsonDouble$.MODULE$.apply(value));
        }
        return this.fromString(Double.toString(value));
    }

    public final Json fromFloatOrString(float value) {
        if (this.isReal(value)) {
            return Json$JNumber$.MODULE$.apply(JsonFloat$.MODULE$.apply(value));
        }
        return this.fromString(Float.toString(value));
    }

    public final Json fromBigInt(BigInt value) {
        return Json$JNumber$.MODULE$.apply(JsonBiggerDecimal$.MODULE$.apply(BiggerDecimal$.MODULE$.fromBigInteger(value.underlying()), value.toString()));
    }

    public final Json fromBigIntOrNull(Option<BigInt> value2) {
        return (Json)value2.fold(Json$::fromBigIntOrNull$$anonfun$1, (Function1 & Serializable)value -> MODULE$.fromBigInt((BigInt)value));
    }

    public final Json fromBigDecimal(BigDecimal value) {
        return Json$JNumber$.MODULE$.apply(JsonBigDecimal$.MODULE$.apply(value.underlying()));
    }

    public final Json fromBigDecimalOrNull(Option<BigDecimal> value2) {
        return (Json)value2.fold(Json$::fromBigDecimalOrNull$$anonfun$1, (Function1 & Serializable)value -> MODULE$.fromBigDecimal((BigDecimal)value));
    }

    private boolean isReal(double value) {
        return Double.isFinite(value);
    }

    private boolean isReal(float value) {
        return Float.isFinite(value);
    }

    private final boolean arrayEq(Vector<Json> x, Vector<Json> y) {
        if (x.length() != y.length()) {
            return false;
        }
        Iterator it0 = x.iterator();
        Iterator it1 = y.iterator();
        while (it0.hasNext()) {
            if (!this.eqJson().neqv(it0.next(), it1.next())) continue;
            return false;
        }
        return true;
    }

    public final Eq<Json> eqJson() {
        return eqJson;
    }

    public final Show<Json> showJson() {
        return showJson;
    }

    public int ordinal(Json x$0) {
        Json json = x$0;
        if (json == Json$JNull$.MODULE$) {
            return 0;
        }
        if (json instanceof Json.JBoolean) {
            return 1;
        }
        if (json instanceof Json.JNumber) {
            return 2;
        }
        if (json instanceof Json.JString) {
            return 3;
        }
        if (json instanceof Json.JArray) {
            return 4;
        }
        if (json instanceof Json.JObject) {
            return 5;
        }
        throw new MatchError((Object)json);
    }

    private static final Json fromStringOrNull$$anonfun$1() {
        return MODULE$.Null();
    }

    private static final Json fromBooleanOrNull$$anonfun$1() {
        return MODULE$.Null();
    }

    private static final Json fromIntOrNull$$anonfun$1() {
        return MODULE$.Null();
    }

    private static final Json fromLongOrNull$$anonfun$1() {
        return MODULE$.Null();
    }

    private static final Json fromDoubleOrNull$$anonfun$1() {
        return MODULE$.Null();
    }

    private static final Json fromFloatOrNull$$anonfun$1() {
        return MODULE$.Null();
    }

    private static final Json fromBigIntOrNull$$anonfun$1() {
        return MODULE$.Null();
    }

    private static final Json fromBigDecimalOrNull$$anonfun$1() {
        return MODULE$.Null();
    }
}

