/*
 * Decompiled with CFR 0.152.
 */
package io.circe.cursor;

import io.circe.ACursor;
import io.circe.CursorOp;
import io.circe.CursorOp$DeleteGoParent$;
import io.circe.CursorOp$Field$;
import io.circe.CursorOp$MoveLeft$;
import io.circe.CursorOp$MoveRight$;
import io.circe.CursorOp$MoveUp$;
import io.circe.HCursor;
import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonObject;
import scala.None$;
import scala.Option;
import scala.Some$;

public final class ObjectCursor
extends HCursor {
    private final JsonObject obj;
    private final String keyValue;
    private final HCursor parent;
    private final boolean changed;

    public ObjectCursor(JsonObject obj, String keyValue, HCursor parent, boolean changed, HCursor lastCursor, CursorOp lastOp) {
        this.obj = obj;
        this.keyValue = keyValue;
        this.parent = parent;
        this.changed = changed;
        super(lastCursor, lastOp);
    }

    public String keyValue() {
        return this.keyValue;
    }

    public HCursor parent() {
        return this.parent;
    }

    @Override
    public Json value() {
        return this.obj.applyUnsafe(this.keyValue());
    }

    @Override
    public Option<Object> index() {
        return None$.MODULE$;
    }

    @Override
    public Option<String> key() {
        return Some$.MODULE$.apply((Object)this.keyValue());
    }

    @Override
    public HCursor replace(Json newValue, HCursor cursor, CursorOp op) {
        return new ObjectCursor(this.obj.add(this.keyValue(), newValue), this.keyValue(), this.parent(), true, cursor, op);
    }

    @Override
    public HCursor addOp(HCursor cursor, CursorOp op) {
        return new ObjectCursor(this.obj, this.keyValue(), this.parent(), this.changed, cursor, op);
    }

    @Override
    public ACursor up() {
        if (!this.changed) {
            return this.parent().addOp(this, CursorOp$MoveUp$.MODULE$);
        }
        return this.parent().replace(Json$.MODULE$.fromJsonObject(this.obj), this, CursorOp$MoveUp$.MODULE$);
    }

    @Override
    public ACursor delete() {
        return this.parent().replace(Json$.MODULE$.fromJsonObject(this.obj.remove(this.keyValue())), this, CursorOp$DeleteGoParent$.MODULE$);
    }

    @Override
    public ACursor field(String k) {
        if (!this.obj.contains(k)) {
            return this.fail(CursorOp$Field$.MODULE$.apply(k));
        }
        return new ObjectCursor(this.obj, k, this.parent(), this.changed, this, CursorOp$Field$.MODULE$.apply(k));
    }

    @Override
    public ACursor left() {
        return this.fail(CursorOp$MoveLeft$.MODULE$);
    }

    @Override
    public ACursor right() {
        return this.fail(CursorOp$MoveRight$.MODULE$);
    }
}

