/*
 * Decompiled with CFR 0.152.
 */
package com.dragontechnology.barcode;

import com.dragontechnology.barcode.BarcodeElement;
import com.dragontechnology.barcode.BarcodeException;
import com.dragontechnology.barcode.BarcodeStrategy;
import com.dragontechnology.barcode.EncodedBarcode;

public abstract class AbstractBarcodeStrategy
implements BarcodeStrategy {
    protected abstract CharacterCode[] getCodes();

    protected abstract String augmentWithChecksum(String var1) throws BarcodeException;

    protected abstract String preprocess(String var1) throws BarcodeException;

    protected abstract boolean isInterleaved();

    protected abstract char getStartSentinel();

    protected abstract char getStopSentinel();

    protected abstract byte getMarginWidth();

    protected abstract String getBarcodeLabelText(String var1);

    protected abstract String postprocess(String var1);

    @Override
    public EncodedBarcode encode(String string, boolean bl) throws BarcodeException {
        Object object = this.preprocess(string);
        object = bl ? this.augmentWithChecksum((String)object) : object;
        object = this.postprocess((String)object);
        if (this.getStartSentinel() != '\uffff' && ((String)object).indexOf(this.getStartSentinel()) >= 0 || ((String)object).indexOf(this.getStopSentinel()) >= 0) {
            throw new BarcodeException("Invalid character in barcode");
        }
        if (this.getStartSentinel() != '\uffff') {
            object = this.getStartSentinel() + (String)object;
        }
        object = (String)object + this.getStopSentinel();
        int n = this.computeSize((String)object);
        BarcodeElement[] barcodeElementArray = new BarcodeElement[n];
        barcodeElementArray[0] = new BarcodeElement();
        barcodeElementArray[0].bar = false;
        barcodeElementArray[0].width = this.getMarginWidth();
        int n2 = ((String)object).length();
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            char c = ((String)object).charAt(i);
            CharacterCode characterCode = this.getCharacterCode(c);
            if (characterCode == null) {
                throw new BarcodeException("Invalid character in barcode");
            }
            for (int j = 0; j < characterCode.widths.length; ++j) {
                barcodeElementArray[n3] = new BarcodeElement();
                barcodeElementArray[n3].width = characterCode.widths[j];
                boolean bl2 = barcodeElementArray[n3].bar = n3 % 2 != 0;
                if (this.isInterleaved() && c != this.getStartSentinel() && c != this.getStopSentinel()) {
                    n3 += 2;
                    continue;
                }
                ++n3;
            }
            if (!this.isInterleaved() || c == this.getStartSentinel() || c == this.getStopSentinel()) continue;
            if (i % 2 == 1) {
                n3 -= characterCode.widths.length * 2 - 1;
                continue;
            }
            --n3;
        }
        barcodeElementArray[n3] = new BarcodeElement();
        barcodeElementArray[n3].bar = false;
        barcodeElementArray[n3].width = this.getMarginWidth();
        if (++n3 != n) {
            throw new BarcodeException("Unexpected barcode size");
        }
        return new EncodedBarcode(barcodeElementArray, this.getBarcodeLabelText(string));
    }

    protected int computeSize(String string) throws BarcodeException {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            CharacterCode characterCode = this.getCharacterCode(c);
            if (characterCode == null) {
                throw new BarcodeException("Invalid character in barcode");
            }
            n += characterCode.widths.length;
        }
        return n += 2;
    }

    protected CharacterCode getCharacterCode(char c) {
        CharacterCode[] characterCodeArray = this.getCodes();
        for (int i = 0; i < characterCodeArray.length; ++i) {
            if (characterCodeArray[i].character != c) continue;
            return characterCodeArray[i];
        }
        return null;
    }

    protected CharacterCode getCharacterCode(int n) {
        CharacterCode[] characterCodeArray = this.getCodes();
        for (int i = 0; i < characterCodeArray.length; ++i) {
            if (characterCodeArray[i].check != n) continue;
            return characterCodeArray[i];
        }
        return null;
    }

    protected static class CharacterCode {
        public char character;
        public byte[] widths;
        public int check;

        public CharacterCode(char c, byte[] byArray, int n) {
            this.character = c;
            this.widths = byArray;
            this.check = n;
        }
    }
}

