/*
 * Decompiled with CFR 0.152.
 */
package com.dragontechnology.barcode;

import com.dragontechnology.barcode.AbstractBarcodeStrategy;
import com.dragontechnology.barcode.BarcodeException;
import java.io.Serializable;

public class Interleaved25
extends AbstractBarcodeStrategy
implements Serializable {
    private static AbstractBarcodeStrategy.CharacterCode[] codes = new AbstractBarcodeStrategy.CharacterCode[]{new AbstractBarcodeStrategy.CharacterCode('1', new byte[]{3, 1, 1, 1, 3}, 1), new AbstractBarcodeStrategy.CharacterCode('2', new byte[]{1, 3, 1, 1, 3}, 2), new AbstractBarcodeStrategy.CharacterCode('3', new byte[]{3, 3, 1, 1, 1}, 3), new AbstractBarcodeStrategy.CharacterCode('4', new byte[]{1, 1, 3, 1, 3}, 4), new AbstractBarcodeStrategy.CharacterCode('5', new byte[]{3, 1, 3, 1, 1}, 5), new AbstractBarcodeStrategy.CharacterCode('6', new byte[]{1, 3, 3, 1, 1}, 6), new AbstractBarcodeStrategy.CharacterCode('7', new byte[]{1, 1, 1, 3, 3}, 7), new AbstractBarcodeStrategy.CharacterCode('8', new byte[]{3, 1, 1, 3, 1}, 8), new AbstractBarcodeStrategy.CharacterCode('9', new byte[]{1, 3, 1, 3, 1}, 9), new AbstractBarcodeStrategy.CharacterCode('0', new byte[]{1, 1, 3, 3, 1}, 0), new AbstractBarcodeStrategy.CharacterCode('A', new byte[]{1, 1, 1, 1}, -1), new AbstractBarcodeStrategy.CharacterCode('B', new byte[]{3, 1, 1}, -1)};

    @Override
    public int requiresChecksum() {
        return 2;
    }

    @Override
    protected AbstractBarcodeStrategy.CharacterCode[] getCodes() {
        return codes;
    }

    @Override
    protected String augmentWithChecksum(String object) throws BarcodeException {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < ((String)object).length(); ++n) {
            char c = ((String)object).charAt(n);
            AbstractBarcodeStrategy.CharacterCode characterCode = this.getCharacterCode(c);
            if (characterCode == null) {
                throw new BarcodeException("Invalid character in barcode");
            }
            if (characterCode.check <= 0) continue;
            if ((n + ((String)object).length()) % 2 == 0) {
                n2 += characterCode.check;
                continue;
            }
            n3 += characterCode.check;
        }
        n = (10 - (n2 + (n3 *= 3)) % 10) % 10;
        object = (String)object + Integer.valueOf(n).toString();
        return object;
    }

    @Override
    protected String postprocess(String object) {
        if (((String)object).length() % 2 != 0) {
            object = "0" + (String)object;
        }
        return object;
    }

    @Override
    protected String preprocess(String string) {
        return string;
    }

    @Override
    protected boolean isInterleaved() {
        return true;
    }

    @Override
    protected char getStartSentinel() {
        return 'A';
    }

    @Override
    protected char getStopSentinel() {
        return 'B';
    }

    @Override
    protected byte getMarginWidth() {
        return 11;
    }

    @Override
    protected String getBarcodeLabelText(String string) {
        return string;
    }
}

