/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.job;

import com.elixirtech.api.SchedulerAPI;
import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.job.IJobLog;
import com.elixirtech.arch.job.IJobLogging;
import com.elixirtech.arch.job.JobAuthentication$;
import com.elixirtech.arch.job.JobEnded$;
import com.elixirtech.arch.job.JobEntry;
import com.elixirtech.arch.job.JobInfo$;
import com.elixirtech.arch.job.JobLog;
import com.elixirtech.arch.job.JobLogging$;
import com.elixirtech.arch.job.JobResult;
import com.elixirtech.arch.job.JobStarted$;
import com.elixirtech.arch.security.Authentication$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;

public class JobLogging
implements IJobLogging {
    private final String jobType;
    private final ListBuffer entries;
    private final LoggingHelper.Level level;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(JobLogging$.class.getDeclaredField("log$lzy1"));

    public static Nothing$ cancel() {
        return JobLogging$.MODULE$.cancel();
    }

    public static Option<Object> elapsed(List<JobEntry> list) {
        return JobLogging$.MODULE$.elapsed(list);
    }

    public static void exception(Throwable throwable) {
        JobLogging$.MODULE$.exception(throwable);
    }

    public static IJobLogging getInstance() {
        return JobLogging$.MODULE$.getInstance();
    }

    public static LoggingHelper.Level getLogLevel(String string) {
        return JobLogging$.MODULE$.getLogLevel(string);
    }

    public static Option<JobResult> lastResult() {
        return JobLogging$.MODULE$.lastResult();
    }

    public static LoggingInterface log() {
        return JobLogging$.MODULE$.log();
    }

    public static void logDebug(String string, String string2) {
        JobLogging$.MODULE$.logDebug(string, string2);
    }

    public static void logError(String string, String string2) {
        JobLogging$.MODULE$.logError(string, string2);
    }

    public static void logError(String string, String string2, Exception exception) {
        JobLogging$.MODULE$.logError(string, string2, exception);
    }

    public static void logInfo(String string, String string2) {
        JobLogging$.MODULE$.logInfo(string, string2);
    }

    public static void logWarn(String string, String string2) {
        JobLogging$.MODULE$.logWarn(string, string2);
    }

    public static <JOBLOG, T> Tuple2<IJobLog, Option<T>> run(IJobLogging iJobLogging, Function0<T> function0) {
        return JobLogging$.MODULE$.run(iJobLogging, function0);
    }

    public static <T> Tuple2<IJobLog, Option<T>> run(String string, Function0<T> function0) {
        return JobLogging$.MODULE$.run(string, function0);
    }

    public static IJobLog run(String string, Runnable runnable) {
        return JobLogging$.MODULE$.run(string, runnable);
    }

    public static <JOBLOG, T> Tuple2<IJobLog, Option<T>> runNested(IJobLogging iJobLogging, Function0<T> function0) {
        return JobLogging$.MODULE$.runNested(iJobLogging, function0);
    }

    public static SchedulerAPI.TriggerStatus status(JobEntry jobEntry) {
        return JobLogging$.MODULE$.status(jobEntry);
    }

    public static SchedulerAPI.TriggerStatus statusCode(List<JobEntry> list) {
        return JobLogging$.MODULE$.statusCode(list);
    }

    public static String summary(List<JobEntry> list) {
        return JobLogging$.MODULE$.summary(list);
    }

    public static Nothing$ unableToComplete(String string) {
        return JobLogging$.MODULE$.unableToComplete(string);
    }

    public JobLogging(String jobType) {
        this.jobType = jobType;
        this.entries = new ListBuffer();
        this.level = JobLogging$.MODULE$.getLogLevel(jobType);
        this.add(JobAuthentication$.MODULE$.apply(Authentication$.MODULE$.domain().name(), Authentication$.MODULE$.username(), JobAuthentication$.MODULE$.$lessinit$greater$default$3()));
    }

    public ListBuffer<JobEntry> entries() {
        return this.entries;
    }

    @Override
    public LoggingHelper.Level level() {
        return this.level;
    }

    @Override
    public void add(JobEntry entry) {
        this.entries().$plus$eq((Object)entry);
    }

    @Override
    public JobLog getJobLog() {
        return new JobLog((List<JobEntry>)this.entries().toList());
    }

    @Override
    public Option<JobResult> lastJobResult() {
        return ((ListBuffer)this.entries().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(JobEntry x) {
                JobEntry jobEntry = x;
                if (jobEntry instanceof JobResult) {
                    JobResult e = (JobResult)jobEntry;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(JobEntry x, Function1 function1) {
                JobEntry jobEntry = x;
                if (jobEntry instanceof JobResult) {
                    JobResult e = (JobResult)jobEntry;
                    return e;
                }
                return function1.apply((Object)x);
            }
        })).lastOption();
    }

    @Override
    public void begin() {
        this.add(JobStarted$.MODULE$.apply(JobStarted$.MODULE$.$lessinit$greater$default$1()));
        this.add(JobInfo$.MODULE$.apply(this.jobType, "Begin " + this.jobType, JobInfo$.MODULE$.$lessinit$greater$default$3()));
    }

    @Override
    public void end() {
        this.add(JobInfo$.MODULE$.apply(this.jobType, "End " + this.jobType, JobInfo$.MODULE$.$lessinit$greater$default$3()));
        this.add(JobEnded$.MODULE$.apply(JobEnded$.MODULE$.$lessinit$greater$default$1()));
    }

    public static class JobCancelledException
    extends RuntimeException {
        public JobCancelledException() {
            super("cancelled");
        }
    }

    public static class JobLogClosedException
    extends RuntimeException {
        public JobLogClosedException() {
            super("close error");
        }
    }

    public static class JobUnableToCompleteException
    extends RuntimeException {
        public JobUnableToCompleteException(String msg) {
            super(msg);
        }
    }
}

