/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.job;

import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.job.IJobLogging;
import com.elixirtech.arch.job.JobEnded$;
import com.elixirtech.arch.job.JobEntry;
import com.elixirtech.arch.job.JobInfo$;
import com.elixirtech.arch.job.JobLog;
import com.elixirtech.arch.job.JobResult;
import com.elixirtech.arch.job.JobStarted$;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;

public class NestedJobLogging<T>
implements IJobLogging {
    private final IJobLogging parent;
    private final String jobType;
    private final LoggingHelper.Level level;
    private final ListBuffer entries;

    public NestedJobLogging(IJobLogging parent, String jobType) {
        this.parent = parent;
        this.jobType = jobType;
        this.level = parent.level();
        this.entries = new ListBuffer();
    }

    @Override
    public LoggingHelper.Level level() {
        return this.level;
    }

    public ListBuffer<JobEntry> entries() {
        return this.entries;
    }

    @Override
    public void begin() {
        this.add(JobStarted$.MODULE$.apply(JobStarted$.MODULE$.$lessinit$greater$default$1()));
        this.add(JobInfo$.MODULE$.apply(this.jobType, "Begin " + this.jobType, JobInfo$.MODULE$.$lessinit$greater$default$3()));
    }

    @Override
    public void end() {
        this.add(JobInfo$.MODULE$.apply(this.jobType, "End " + this.jobType, JobInfo$.MODULE$.$lessinit$greater$default$3()));
        this.add(JobEnded$.MODULE$.apply(JobEnded$.MODULE$.$lessinit$greater$default$1()));
    }

    @Override
    public void add(JobEntry entry) {
        this.entries().$plus$eq((Object)entry);
        this.parent.add(entry);
    }

    @Override
    public JobLog getJobLog() {
        return new JobLog((List<JobEntry>)this.entries().toList());
    }

    @Override
    public Option<JobResult> lastJobResult() {
        return this.parent.lastJobResult();
    }
}

