/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.security;

import com.elixirtech.arch.Credentials;
import com.elixirtech.arch.Domain;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Name;
import com.elixirtech.arch.Names;
import com.elixirtech.arch.Token;
import com.elixirtech.arch.security.DomainPrincipal;
import com.elixirtech.arch.security.GroupPrincipal;
import com.elixirtech.arch.security.TokenPrincipal;
import com.elixirtech.arch.security.UserPrincipal;
import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.swing.SwingUtilities;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Option$;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.DynamicVariable;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class Authentication$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Authentication$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final DynamicVariable<Credentials> _identity;
    public static final Authentication$ MODULE$;

    private Authentication$() {
    }

    static {
        MODULE$ = new Authentication$();
        _identity = new DynamicVariable(null);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Authentication$.class);
    }

    public Credentials credentials() {
        return (Credentials)_identity.value();
    }

    public Domain domain() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public String username() {
        return ((Credentials)_identity.value()).username();
    }

    public Token token() {
        return ((Credentials)_identity.value()).token();
    }

    public scala.collection.immutable.Set<String> groups() {
        return ((Credentials)_identity.value()).groups();
    }

    public boolean isAuthenticated() {
        return Option$.MODULE$.apply(_identity.value()).isDefined();
    }

    public boolean isAnon() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public boolean changePassword() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public <Q> Q withCredentials(Credentials creds, Function0<Q> fn) {
        return this.setCredentials(creds, fn);
    }

    public void withCredentials(Credentials creds, Runnable r) {
        this.setCredentials(creds, (Function0 & Serializable)() -> {
            Authentication$.withCredentials$$anonfun$1(r);
            return BoxedUnit.UNIT;
        });
    }

    public <A, Q> Q withCredentials(Credentials creds, A a, Function1<A, Q> fn) {
        return this.setCredentials(creds, () -> Authentication$.withCredentials$$anonfun$2(fn, a));
    }

    public <A, B, Q> Q withCredentials(Credentials creds, A a, B b, Function2<A, B, Q> fn) {
        return this.setCredentials(creds, () -> Authentication$.withCredentials$$anonfun$3(fn, a, b));
    }

    public <A, B, C, Q> Q withCredentials(Credentials creds, A a, B b, C c, Function3<A, B, C, Q> fn) {
        return this.setCredentials(creds, () -> Authentication$.withCredentials$$anonfun$4(fn, a, b, c));
    }

    public boolean isAdmin() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public boolean hasGroup(String g) {
        String string = this.username();
        String string2 = g;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return true;
        }
        scala.collection.immutable.Set<String> all = this.groups();
        if (g.endsWith("*")) {
            String test = g.substring(0, g.length() - 1);
            return all.exists((Function1 & Serializable)_$1 -> _$1.startsWith(test));
        }
        if (g.endsWith("!")) {
            return all.contains((Object)g.substring(0, g.length() - 1));
        }
        return this.groups().contains((Object)g);
    }

    public boolean hasGroup(scala.collection.immutable.Set<String> gs) {
        if (gs.contains((Object)this.username())) {
            return true;
        }
        scala.collection.immutable.Set<String> all = this.groups();
        return gs.exists((Function1 & Serializable)g -> {
            if (g.endsWith("*")) {
                String test = g.substring(0, g.length() - 1);
                return all.exists((Function1 & Serializable)_$2 -> _$2.startsWith(test));
            }
            if (g.endsWith("!")) {
                return all.contains((Object)g.substring(0, g.length() - 1));
            }
            return all.contains(g);
        });
    }

    public boolean hasGroup(Names names) {
        return this.hasGroup((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)names.values().map((Function1 & Serializable)_$3 -> _$3 == null ? null : ((Name)_$3).value())));
    }

    public void swingCredentials(Credentials creds) {
        if ("true".equals(System.getProperty("java.awt.headless"))) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.com$elixirtech$arch$security$Authentication$$$_$setValues$1(creds);
            return;
        }
        SwingUtilities.invokeAndWait(new Runnable(creds){
            private final Credentials creds$2;
            {
                this.creds$2 = creds$3;
            }

            public void run() {
                Authentication$.MODULE$.com$elixirtech$arch$security$Authentication$$$_$setValues$1(this.creds$2);
            }
        });
    }

    public Credentials getCredentials(Subject subject) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Subject getSubject(Credentials creds) {
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add(new TokenPrincipal(creds.token().value()));
        principals.add(new UserPrincipal(creds.username()));
        creds.groups().foreach((Function1 & Serializable)g -> principals.add(new GroupPrincipal((String)g)));
        HashSet empty = new HashSet();
        return new Subject(false, principals, empty, empty);
    }

    public boolean isValidSubject(Subject subject) {
        Set<TokenPrincipal> tokens = subject.getPrincipals(TokenPrincipal.class);
        Set<DomainPrincipal> domains = subject.getPrincipals(DomainPrincipal.class);
        Set<UserPrincipal> users = subject.getPrincipals(UserPrincipal.class);
        if (tokens.size() != 1) {
            this.log().error(() -> Authentication$.isValidSubject$$anonfun$1(tokens), Line$.MODULE$.apply(133), FullName$.MODULE$.apply("com.elixirtech.arch.security.Authentication.isValidSubject"));
            return false;
        }
        if (domains.size() != 1) {
            this.log().error(() -> Authentication$.isValidSubject$$anonfun$2(domains), Line$.MODULE$.apply(137), FullName$.MODULE$.apply("com.elixirtech.arch.security.Authentication.isValidSubject"));
            return false;
        }
        if (users.size() != 1) {
            this.log().error(() -> Authentication$.isValidSubject$$anonfun$3(users), Line$.MODULE$.apply(141), FullName$.MODULE$.apply("com.elixirtech.arch.security.Authentication.isValidSubject"));
            return false;
        }
        return true;
    }

    private <Q> Q setCredentials(Credentials c, Function0<Q> fn) {
        return (Q)_identity.withValue((Object)c, () -> Authentication$.setCredentials$$anonfun$1(fn));
    }

    private static final void withCredentials$$anonfun$1(Runnable r$1) {
        r$1.run();
    }

    private static final Object withCredentials$$anonfun$2(Function1 fn$1, Object a$1) {
        return fn$1.apply(a$1);
    }

    private static final Object withCredentials$$anonfun$3(Function2 fn$2, Object a$2, Object b$1) {
        return fn$2.apply(a$2, b$1);
    }

    private static final Object withCredentials$$anonfun$4(Function3 fn$3, Object a$3, Object b$2, Object c$1) {
        return fn$3.apply(a$3, b$2, c$1);
    }

    public final void com$elixirtech$arch$security$Authentication$$$_$setValues$1(Credentials creds$1) {
        _identity.value_$eq((Object)creds$1);
    }

    private static final Object isValidSubject$$anonfun$1(Set tokens$1) {
        return "subject has " + tokens$1.size() + " TokenPrincipal(s)";
    }

    private static final Object isValidSubject$$anonfun$2(Set domains$1) {
        return "subject has " + domains$1.size() + " DomainPrincipal(s)";
    }

    private static final Object isValidSubject$$anonfun$3(Set users$1) {
        return "subject has " + users$1.size() + " UserPrincipal(s)";
    }

    private static final Object setCredentials$$anonfun$1(Function0 fn$4) {
        return fn$4.apply();
    }
}

