/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.awt;

import com.elixirtech.awt.Alignment;
import com.elixirtech.awt.TextBlock;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;

public class Text
implements Alignment {
    public String m_Text;
    public int m_Width;
    public Point m_StartPoint;

    public static String withoutNL(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            if (stringBuffer.charAt(i) != '\n') continue;
            stringBuffer.setCharAt(i, ' ');
        }
        return stringBuffer.toString();
    }

    public static String spacesAtCaps(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        for (int i = 1; i < n; ++i) {
            if (!Character.isUpperCase(stringBuffer.charAt(i)) || Character.isUpperCase(stringBuffer.charAt(i - 1))) continue;
            stringBuffer.insert(i, ' ');
            ++n;
            ++i;
        }
        return stringBuffer.toString();
    }

    public static void drawBaseline(Graphics graphics, Point point, int n, String string) {
        if (string.length() == 0) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (n == 1) {
            graphics.drawString(string, point.x, point.y);
        } else if (n == 2) {
            int n2 = fontMetrics.stringWidth(string);
            graphics.drawString(string, point.x - n2, point.y);
        } else {
            int n3 = fontMetrics.stringWidth(string);
            graphics.drawString(string, point.x - n3 / 2, point.y);
        }
    }

    public static void drawTop(Graphics graphics, Point point, int n, String string) {
        if (string.length() == 0) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = point.y + fontMetrics.getHeight();
        if (n == 1) {
            graphics.drawString(string, point.x, n2);
        } else if (n == 2) {
            int n3 = fontMetrics.stringWidth(string);
            graphics.drawString(string, point.x - n3, n2);
        } else {
            int n4 = fontMetrics.stringWidth(string);
            graphics.drawString(string, point.x - n4 / 2, point.y);
        }
    }

    public static void drawBottom(Graphics graphics, Point point, int n, String string) {
        if (string.length() == 0) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = point.y - fontMetrics.getDescent();
        if (n == 1) {
            graphics.drawString(string, point.x, n2);
        } else if (n == 2) {
            int n3 = fontMetrics.stringWidth(string);
            graphics.drawString(string, point.x - n3, n2);
        } else {
            int n4 = fontMetrics.stringWidth(string);
            graphics.drawString(string, point.x - n4 / 2, n2);
        }
    }

    public static void drawVCenter(Graphics graphics, Point point, int n, String string) {
        if (string.length() == 0) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = point.y + fontMetrics.getAscent() / 2;
        if (n == 1) {
            graphics.drawString(string, point.x, n2);
        } else if (n == 2) {
            int n3 = fontMetrics.stringWidth(string);
            graphics.drawString(string, point.x - n3, n2);
        } else {
            int n4 = fontMetrics.stringWidth(string);
            graphics.drawString(string, point.x - n4 / 2, point.y);
        }
    }

    public static void drawBaseline(Graphics graphics, int n, int n2, int n3, String string) {
        Text.drawBaseline(graphics, new Point(n, n2), n3, string);
    }

    public static void drawVCenter(Graphics graphics, int n, int n2, int n3, String string) {
        Text.drawVCenter(graphics, new Point(n, n2), n3, string);
    }

    public static void drawTop(Graphics graphics, int n, int n2, int n3, String string) {
        Text.drawTop(graphics, new Point(n, n2), n3, string);
    }

    public static void drawBottom(Graphics graphics, int n, int n2, int n3, String string) {
        Text.drawBottom(graphics, new Point(n, n2), n3, string);
    }

    public static int getIndexFromPixelPos(String string, TextBlock textBlock, int n) {
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n3 = textBlock.stringWidth(string.substring(0, i));
            if (n3 > n) {
                int n4 = n3 - n;
                int n5 = n - n2;
                if (n4 < n5 || i == 0) {
                    return i;
                }
                return i - 1;
            }
            n2 = n3;
        }
        return string.length();
    }

    public Text(String string, int n) {
        this.m_Text = string;
        this.m_Width = n;
    }
}

