/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.barcode;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ElxLoggerJ$;
import com.elixirtech.barcode.Barcode2DBean;
import com.elixirtech.barcode.IBarcodeBean;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.PDF417Writer;
import com.google.zxing.pdf417.encoder.Compaction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import scala.Option$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public class PDF417Bean
extends JComponent
implements IBarcodeBean,
Barcode2DBean {
    private int WHITE;
    private int BLACK;
    private double m_Angle;
    private String m_Value;
    private HashMap m_Hints;
    private final ElxLoggerJ m_Logger;
    private final PDF417Writer m_Writer;
    private boolean m_Compaction;
    private int m_Resolution;
    private Compaction m_CompactMode;

    public PDF417Bean() {
        Barcode2DBean.$init$(this);
        this.m_Logger = ElxLoggerJ$.MODULE$.getLogger(PDF417Bean.class);
        this.m_Writer = new PDF417Writer();
        this.m_Compaction = false;
        this.m_Resolution = 2;
        this.m_CompactMode = Compaction.AUTO;
        Statics.releaseFence();
    }

    @Override
    public int WHITE() {
        return this.WHITE;
    }

    @Override
    public int BLACK() {
        return this.BLACK;
    }

    @Override
    public double m_Angle() {
        return this.m_Angle;
    }

    @Override
    public String m_Value() {
        return this.m_Value;
    }

    public HashMap m_Hints() {
        return this.m_Hints;
    }

    @Override
    public void m_Angle_$eq(double x$1) {
        this.m_Angle = x$1;
    }

    @Override
    public void m_Value_$eq(String x$1) {
        this.m_Value = x$1;
    }

    @Override
    public void com$elixirtech$barcode$Barcode2DBean$_setter_$WHITE_$eq(int x$0) {
        this.WHITE = x$0;
    }

    @Override
    public void com$elixirtech$barcode$Barcode2DBean$_setter_$BLACK_$eq(int x$0) {
        this.BLACK = x$0;
    }

    @Override
    public void com$elixirtech$barcode$Barcode2DBean$_setter_$m_Hints_$eq(HashMap x$0) {
        this.m_Hints = x$0;
    }

    public ElxLoggerJ m_Logger() {
        return this.m_Logger;
    }

    public PDF417Writer m_Writer() {
        return this.m_Writer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCompactMode(String mode) {
        Compaction compaction;
        block6: {
            String string = mode;
            switch (string == null ? 0 : string.hashCode()) {
                case -335760659: {
                    if (!"Numeric".equals(string)) break;
                    compaction = Compaction.NUMERIC;
                    break block6;
                }
                case 2052559: {
                    if (!"Auto".equals(string)) break;
                    compaction = Compaction.AUTO;
                    break block6;
                }
                case 2086184: {
                    if (!"Byte".equals(string)) break;
                    compaction = Compaction.BYTE;
                    break block6;
                }
                case 2603341: {
                    if (!"Text".equals(string)) break;
                    compaction = Compaction.TEXT;
                    break block6;
                }
            }
            this.m_Logger().warn((Object)("Mode " + mode + " not recognized. Use Auto as default."));
            compaction = Compaction.AUTO;
        }
        this.m_CompactMode_$eq(compaction);
    }

    public void setCompaction(boolean isCompact) {
        this.m_Compaction_$eq(isCompact);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension sz = this.getSize();
        Color bg = (Color)Option$.MODULE$.apply((Object)this.getBackground()).getOrElse(PDF417Bean::$anonfun$1);
        g2.setColor(bg);
        g2.fill(this.getVisibleRect());
        try {
            int width = (int)sz.getWidth();
            int height = (int)sz.getHeight();
            this.m_Hints().put(EncodeHintType.PDF417_COMPACT, BoxesRunTime.boxToBoolean((boolean)this.m_Compaction()));
            this.m_Hints().put(EncodeHintType.PDF417_COMPACTION, this.m_CompactMode());
            this.m_Hints().put(EncodeHintType.CHARACTER_SET, "UTF8");
            BitMatrix bm = this.m_Writer().encode(this.m_Value(), BarcodeFormat.PDF_417, width, height, (Map)this.m_Hints());
            this.renderImage(g2, bm, sz, this);
        }
        catch (Exception ex) {
            this.m_Logger().error((Object)("Unable to generate PDF417 barcode with value " + this.m_Value() + "." + ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public boolean m_Compaction() {
        return this.m_Compaction;
    }

    public void m_Compaction_$eq(boolean x$1) {
        this.m_Compaction = x$1;
    }

    public int m_Resolution() {
        return this.m_Resolution;
    }

    public void m_Resolution_$eq(int x$1) {
        this.m_Resolution = x$1;
    }

    public Compaction m_CompactMode() {
        return this.m_CompactMode;
    }

    public void m_CompactMode_$eq(Compaction x$1) {
        this.m_CompactMode = x$1;
    }

    private static final Color $anonfun$1() {
        return Color.WHITE;
    }
}

