/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.corego;

import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.geometry.RectangleEx;
import com.elixirtech.ensemble.canvas.JoinGO;
import java.awt.Point;

public class Connection {
    protected GO m_GO;
    protected double m_XRatio;
    protected double m_YRatio;

    public Connection(GO gO) {
        this.m_GO = gO;
    }

    public GO getGO() {
        return this.m_GO;
    }

    public void setPoint(Point point) {
        RectangleEx rectangleEx = this.m_GO.getSnapRect();
        this.m_XRatio = (double)(point.x - rectangleEx.left) / (double)rectangleEx.width();
        this.m_YRatio = (double)(point.y - rectangleEx.top) / (double)rectangleEx.height();
        if (this.m_GO instanceof JoinGO) {
            System.out.println("Connection setPoint(" + String.valueOf(point) + ") " + String.valueOf(this.m_GO.getSnapRect()) + " xr=" + this.m_XRatio + " yr=" + this.m_YRatio);
        }
    }

    public Point snapToEdge(Point point) {
        return this.m_GO.snapToEdge(point);
    }

    public Point getPoint() {
        RectangleEx rectangleEx = this.m_GO.getSnapRect();
        int n = (int)((double)rectangleEx.left + (double)rectangleEx.width() * this.m_XRatio);
        int n2 = (int)((double)rectangleEx.top + (double)rectangleEx.height() * this.m_YRatio);
        return new Point(n, n2);
    }

    public String toString() {
        return "Connection(" + String.valueOf(this.m_GO) + ",xr=" + this.m_XRatio + ",yr=" + this.m_YRatio + " gives " + this.getPoint().toString();
    }
}

