/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.corego;

import com.elixirtech.canvas.corego.Connection;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.MovingConnection;
import com.elixirtech.canvas.geometry.Geometry;
import com.elixirtech.canvas.geometry.RectangleEx;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.canvas.graph.Relationship;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class ConnectorGO
extends GO {
    protected Connection m_Start;
    protected Connection m_Stop;
    protected Point[] m_Points = new Point[2];
    static final int CONTAINS_DISTANCE = 5;
    static final Point GRIDSIZE = new Point(5, 5);
    protected static final String POINTS = "points";

    public Relationship createModel(Node node, Node node2) {
        return null;
    }

    public abstract String getTypeName();

    @Override
    public abstract Point snapToEdge(Point var1);

    @Override
    public RectangleEx getSnapRect() {
        return this.getPaintRect();
    }

    @Override
    public boolean contains(Point point) {
        try {
            RectangleEx rectangleEx = this.getPaintRect().grow(5);
            if (!rectangleEx.contains(point)) {
                return false;
            }
            return this.lineContains(point);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected boolean lineContains(Point point) {
        Point[] pointArray = this.getPoints();
        for (int i = 0; i < pointArray.length - 1; ++i) {
            Point point2 = pointArray[i];
            Point point3 = pointArray[i + 1];
            double d = Geometry.distanceToLineInclusive(point2, point3, point);
            if (!(d <= 5.0)) continue;
            return true;
        }
        return false;
    }

    public RectangleEx getPaintRect() {
        Point[] pointArray = this.getPoints();
        RectangleEx rectangleEx = new RectangleEx(pointArray[0].x, pointArray[0].y, pointArray[1].x, pointArray[1].y);
        rectangleEx.normalize();
        for (int i = 2; i < pointArray.length; ++i) {
            Point point = pointArray[i];
            if (rectangleEx.left > point.x) {
                rectangleEx.left = point.x;
            }
            if (rectangleEx.top > point.y) {
                rectangleEx.top = point.y;
            }
            if (rectangleEx.right < point.x) {
                rectangleEx.right = point.x;
            }
            if (rectangleEx.bottom >= point.y) continue;
            rectangleEx.bottom = point.y;
        }
        return rectangleEx.grow(1);
    }

    public GO getStartGO() {
        return this.m_Start.getGO();
    }

    public GO getStopGO() {
        return this.m_Stop.getGO();
    }

    public Connection getStart() {
        return this.m_Start;
    }

    public Connection getStop() {
        return this.m_Stop;
    }

    public void setStart(GO gO, Point point) {
        this.m_Start = gO instanceof ConnectorGO ? new MovingConnection((ConnectorGO)gO) : new Connection(gO);
        this.m_Start.setPoint(point);
        Relationship relationship = gO.connectTo(this, RelType.Repaints);
        relationship.setUserProperty("start", "true");
        Node node = this.getModel();
        Node node2 = gO.getModel();
        if (node != null && node2 != null) {
            node2.connectTo(node, RelType.Connects);
        } else {
            gO.connectTo(this, RelType.Connects);
        }
    }

    public void setStop(GO gO, Point point) {
        this.m_Stop = gO instanceof ConnectorGO ? new MovingConnection((ConnectorGO)gO) : new Connection(gO);
        this.m_Stop.setPoint(point);
        Relationship relationship = gO.connectTo(this, RelType.Repaints);
        relationship.setUserProperty("stop", "true");
        Node node = this.getModel();
        Node node2 = gO.getModel();
        if (node != null && node2 != null) {
            node2.connectTo(node, RelType.Connects);
        } else {
            gO.connectTo(this, RelType.Connects);
        }
    }

    protected void alignPoint(Point point, Point point2) {
        if (Math.abs(point2.x - point.x) < ConnectorGO.GRIDSIZE.x) {
            point.x = point2.x;
        }
        if (Math.abs(point2.y - point.y) < ConnectorGO.GRIDSIZE.y) {
            point.y = point2.y;
        }
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        StringBuffer stringBuffer = new StringBuffer();
        Point[] pointArray = this.getPoints();
        for (int i = 0; i < pointArray.length; ++i) {
            stringBuffer.append("(");
            stringBuffer.append(pointArray[i].x);
            stringBuffer.append(",");
            stringBuffer.append(pointArray[i].y);
            stringBuffer.append(")");
        }
        map.put(POINTS, stringBuffer.toString());
        return map;
    }

    @Override
    public void setProperty(String string, String string2) {
        try {
            if (string.equals(POINTS)) {
                ArrayList<Point> arrayList = new ArrayList<Point>();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " \n\t(),", false);
                while (stringTokenizer.hasMoreElements()) {
                    int n = Integer.parseInt((String)stringTokenizer.nextElement());
                    int n2 = Integer.parseInt((String)stringTokenizer.nextElement());
                    arrayList.add(new Point(n, n2));
                }
                this.m_Points = new Point[arrayList.size()];
                arrayList.toArray(this.m_Points);
            } else {
                super.setProperty(string, string2);
            }
        }
        catch (Throwable throwable) {
            System.out.println("ConnectorGO setProperty " + string + "=" + string2 + " " + String.valueOf(throwable));
        }
    }

    protected void drawStartEnd(Graphics2D graphics2D) {
    }

    protected void drawStopEnd(Graphics2D graphics2D) {
    }

    @Override
    public void addInwardEdge(Relationship relationship) {
        super.addInwardEdge(relationship);
        this.buildInwardEdgeConnector(relationship);
    }

    protected void buildInwardEdgeConnector(Relationship relationship) {
        if (relationship.getRelType() == RelType.Repaints) {
            if (relationship.getUserProperty("start") != null) {
                GO gO = (GO)relationship.getOrigin();
                this.m_Start = gO instanceof ConnectorGO ? new MovingConnection((ConnectorGO)gO) : new Connection(gO);
                this.m_Start.setPoint(this.m_Points[0]);
            } else if (relationship.getUserProperty("stop") != null) {
                GO gO = (GO)relationship.getOrigin();
                this.m_Stop = gO instanceof ConnectorGO ? new MovingConnection((ConnectorGO)gO) : new Connection(gO);
                this.m_Stop.setPoint(this.m_Points[this.m_Points.length - 1]);
            }
        }
    }

    protected Point parsePoint(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(),", false);
        int n = Integer.parseInt((String)stringTokenizer.nextElement());
        int n2 = Integer.parseInt((String)stringTokenizer.nextElement());
        return new Point(n, n2);
    }

    protected String toString(Point point) {
        return "(" + point.x + "," + point.y + ")";
    }

    protected Point[] getPoints() {
        Point[] pointArray = new Point[]{this.m_Start.getPoint(), this.m_Stop.getPoint()};
        return pointArray;
    }
}

