/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.corego;

import com.elixirtech.canvas.corego.Connection;
import com.elixirtech.canvas.corego.ConnectorGO;
import com.elixirtech.canvas.geometry.Geometry;
import com.elixirtech.canvas.geometry.RectangleEx;
import java.awt.Point;

public class MovingConnection
extends Connection {
    int m_Segment = 0;
    int m_NoPoints = 2;
    Point m_Point;
    double m_LenRatio = 0.5;
    boolean m_PointNotInitialized;

    public MovingConnection(ConnectorGO connectorGO) {
        super(connectorGO);
    }

    @Override
    public Point getPoint() {
        Cloneable cloneable;
        Point[] pointArray = ((ConnectorGO)this.m_GO).getPoints();
        if (pointArray == null) {
            return (Point)this.m_Point.clone();
        }
        if (this.m_NoPoints != pointArray.length || this.m_PointNotInitialized) {
            cloneable = this.snapToEdge(this.m_Point);
            this.setPoint((Point)cloneable);
        }
        cloneable = new RectangleEx(pointArray[this.m_Segment], pointArray[this.m_Segment + 1]);
        int n = (int)((double)((RectangleEx)cloneable).left + (double)((RectangleEx)cloneable).width() * this.m_LenRatio);
        int n2 = (int)((double)((RectangleEx)cloneable).top + (double)((RectangleEx)cloneable).height() * this.m_LenRatio);
        this.m_Point = new Point(n, n2);
        return new Point(n, n2);
    }

    @Override
    public void setPoint(Point point) {
        this.m_Point = (Point)point.clone();
        Point[] pointArray = ((ConnectorGO)this.m_GO).getPoints();
        if (pointArray == null) {
            this.m_PointNotInitialized = true;
            return;
        }
        int n = 0;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < pointArray.length - 1; ++i) {
            Point point2 = pointArray[i];
            Point point3 = pointArray[i + 1];
            double d2 = Geometry.distanceToLineInclusive(point2, point3, point);
            if (!(d2 < d)) continue;
            n = i;
            d = d2;
        }
        double d3 = Geometry.distanceBetweenPoints(pointArray[n], pointArray[n + 1]);
        double d4 = Geometry.distanceBetweenPoints(pointArray[n], point);
        this.m_LenRatio = d4 / d3;
        this.m_Segment = n;
        this.m_NoPoints = pointArray.length;
    }

    @Override
    public Point snapToEdge(Point point) {
        Point[] pointArray = ((ConnectorGO)this.m_GO).getPoints();
        int n = 0;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < pointArray.length - 1; ++i) {
            Point point2 = pointArray[i];
            Point point3 = pointArray[i + 1];
            double d2 = Geometry.distanceToLineInclusive(point2, point3, point);
            if (!(d2 < d)) continue;
            n = i;
            d = d2;
        }
        return Geometry.closestPointOnLineInclusive(pointArray[n], pointArray[n + 1], point);
    }
}

