/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.corego;

import com.elixirtech.canvas.corego.ConnectorGO;
import com.elixirtech.canvas.geometry.Geometry;
import java.awt.Point;

public class PolylineConnectorGO
extends ConnectorGO {
    @Override
    public String getTypeName() {
        return "PolylineConnectorGO";
    }

    @Override
    public Point snapToEdge(Point point) {
        Point[] pointArray = this.getPoints();
        int n = 0;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < pointArray.length - 1; ++i) {
            Point point2 = pointArray[i];
            Point point3 = pointArray[i + 1];
            double d2 = Geometry.distanceToLineInclusive(point2, point3, point);
            if (!(d2 < d)) continue;
            n = i;
            d = d2;
        }
        Point point4 = Geometry.closestPointOnLineInclusive(pointArray[n], pointArray[n + 1], point);
        return point4;
    }

    @Override
    protected Point[] getPoints() {
        if (this.m_Start == null) {
            return null;
        }
        Point[] pointArray = new Point[this.m_Points.length];
        pointArray[0] = this.m_Start.getPoint();
        pointArray[this.m_Points.length - 1] = this.m_Stop.getPoint();
        for (int i = 1; i < this.m_Points.length - 1; ++i) {
            pointArray[i] = (Point)this.m_Points[i].clone();
        }
        return pointArray;
    }

    public Point[] getUnsafePoints() {
        this.m_Points[0] = this.m_Start.getPoint();
        this.m_Points[this.m_Points.length - 1] = this.m_Stop.getPoint();
        return this.m_Points;
    }

    public void setUnsafePoints(Point[] pointArray) {
        this.m_Points = pointArray;
    }
}

