/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.geometry;

import com.elixirtech.canvas.geometry.Geometry;
import java.awt.Point;

public class Line {
    private double m_Gradient;
    private double m_C;
    private int m_Slope = 0;
    private Point m_StartPoint;
    private Point m_EndPoint;
    public static final int ANGLE = 0;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;

    public Line(Point point, Point point2) {
        this.m_StartPoint = point;
        this.m_EndPoint = point2;
        if (point.x == point2.x) {
            this.m_Slope = 1;
            this.m_C = point.x;
        } else if (point.y == point2.y) {
            this.m_Slope = 2;
            this.m_C = point.y;
        } else {
            this.m_Gradient = (double)(point.y - point2.y) / (double)(point.x - point2.x);
            this.m_C = (double)point.y - this.m_Gradient * (double)point.x;
        }
    }

    public Point closestPointTo(Point point) {
        if (this.m_Slope == 1) {
            return new Point((int)this.m_C, point.y);
        }
        if (this.m_Slope == 2) {
            return new Point(point.x, (int)this.m_C);
        }
        double d = this.m_Gradient;
        double d2 = this.m_C;
        double d3 = Math.tan(1.5707963267948966 - Math.atan(Math.abs(d)));
        d3 = d < 0.0 ? d3 : -d3;
        double d4 = (double)point.y - d3 * (double)point.x;
        double d5 = (d4 - d2) / (d - d3);
        double d6 = d * d5 + d2;
        return new Point((int)d5, (int)d6);
    }

    public Point closestPointToInclusive(Point point) {
        Point point2 = this.closestPointTo(point);
        if (this.pointOnLineInclusive(point2)) {
            return point2;
        }
        return Geometry.distanceBetweenPoints(this.m_StartPoint, point2) <= Geometry.distanceBetweenPoints(this.m_EndPoint, point2) ? this.m_StartPoint : this.m_EndPoint;
    }

    public double distanceToPoint(Point point) {
        if (this.m_Slope == 1) {
            return Math.abs((double)point.x - this.m_C);
        }
        if (this.m_Slope == 2) {
            return Math.abs((double)point.y - this.m_C);
        }
        double d = this.m_Gradient * (double)point.x - (double)point.y + this.m_C;
        return Math.abs(d / Math.sqrt(Math.pow(this.m_Gradient, 2.0) + 1.0));
    }

    public double distanceToPointInclusive(Point point) {
        Point point2 = this.closestPointTo(point);
        if (this.pointOnLineInclusive(point2)) {
            return this.distanceToPoint(point);
        }
        return Math.min(Geometry.distanceBetweenPoints(this.m_StartPoint, point), Geometry.distanceBetweenPoints(this.m_EndPoint, point));
    }

    public int slope() {
        return this.m_Slope;
    }

    public double gradient() {
        return this.m_Gradient;
    }

    private boolean pointOnLineInclusive(Point point) {
        int n = Math.min(this.m_StartPoint.x, this.m_EndPoint.x);
        int n2 = Math.max(this.m_StartPoint.x, this.m_EndPoint.x);
        int n3 = Math.min(this.m_StartPoint.y, this.m_EndPoint.y);
        int n4 = Math.max(this.m_StartPoint.y, this.m_EndPoint.y);
        if (this.m_Slope == 1) {
            return n3 <= point.y && n4 >= point.y;
        }
        if (this.m_Slope == 2) {
            return n <= point.x && n2 >= point.x;
        }
        return n3 <= point.y && n4 >= point.y && n <= point.x && n2 >= point.x;
    }
}

