/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.geometry;

import com.elixirtech.arch.ElxLoggerJ;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class RectangleEx
implements Cloneable {
    public int left;
    public int top;
    public int right;
    public int bottom;

    public String toString() {
        return "(" + this.left + "," + this.top + "," + this.right + "," + this.bottom + ")";
    }

    public RectangleEx(int n, int n2, int n3, int n4) {
        this.left = n;
        this.top = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public RectangleEx(Point point, Dimension dimension) {
        this.left = point.x;
        this.top = point.y;
        this.right = point.x + dimension.width;
        this.bottom = point.y + dimension.height;
    }

    public RectangleEx(Point point, Point point2) {
        this.left = point.x;
        this.top = point.y;
        this.right = point2.x;
        this.bottom = point2.y;
    }

    public RectangleEx(int n, int n2) {
        this.left = n;
        this.top = n2;
        this.right = n;
        this.bottom = n2;
    }

    public RectangleEx(Point point) {
        this.left = point.x;
        this.top = point.y;
        this.right = point.x;
        this.bottom = point.y;
    }

    public RectangleEx(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "(,)", false);
            this.left = Integer.parseInt(stringTokenizer.nextToken());
            this.top = Integer.parseInt(stringTokenizer.nextToken());
            this.right = Integer.parseInt(stringTokenizer.nextToken());
            this.bottom = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            this.left = 0;
            this.top = 0;
            this.right = 0;
            this.bottom = 0;
            ElxLoggerJ.getLogger(RectangleEx.class).warn((Object)("Error parsing \"" + string + "\": " + String.valueOf(numberFormatException)), (Throwable)numberFormatException);
        }
    }

    public RectangleEx(Rectangle rectangle) {
        this.left = rectangle.x;
        this.top = rectangle.y;
        this.right = rectangle.x + rectangle.width;
        this.bottom = rectangle.y + rectangle.height;
    }

    public Point leftTop() {
        return new Point(this.left, this.top);
    }

    public Point rightTop() {
        return new Point(this.right, this.top);
    }

    public Point leftBottom() {
        return new Point(this.left, this.bottom);
    }

    public Point rightBottom() {
        return new Point(this.right, this.bottom);
    }

    public Point center() {
        return new Point(this.left + (this.right - this.left) / 2, this.top + (this.bottom - this.top) / 2);
    }

    public int verticalCenter() {
        return this.top + (this.bottom - this.top) / 2;
    }

    public int horizontalCenter() {
        return this.left + (this.right - this.left) / 2;
    }

    public void leftTop(Point point) {
        this.left = point.x;
        this.top = point.y;
    }

    public void rightTop(Point point) {
        this.right = point.x;
        this.top = point.y;
    }

    public void leftBottom(Point point) {
        this.left = point.x;
        this.bottom = point.y;
    }

    public void rightBottom(Point point) {
        this.right = point.x;
        this.bottom = point.y;
    }

    public RectangleEx grow(int n) {
        this.left -= n;
        this.top -= n;
        this.right += n;
        this.bottom += n;
        return this;
    }

    public RectangleEx grow(int n, int n2) {
        this.left -= n;
        this.top -= n2;
        this.right += n;
        this.bottom += n2;
        return this;
    }

    public RectangleEx move(int n, int n2) {
        this.left += n;
        this.top += n2;
        this.right += n;
        this.bottom += n2;
        return this;
    }

    public RectangleEx moveTo(Point point) {
        this.right = point.x + this.right - this.left;
        this.bottom = point.y + this.bottom - this.top;
        this.left = point.x;
        this.top = point.y;
        return this;
    }

    public int width() {
        return this.right - this.left;
    }

    public int height() {
        return this.bottom - this.top;
    }

    public RectangleEx normalize() {
        int n;
        if (this.right < this.left) {
            n = this.right;
            this.right = this.left;
            this.left = n;
        }
        if (this.bottom < this.top) {
            n = this.bottom;
            this.bottom = this.top;
            this.top = n;
        }
        return this;
    }

    public boolean isEmpty() {
        if (this.left >= this.right) {
            return true;
        }
        return this.top >= this.bottom;
    }

    public boolean contains(Point point) {
        return point.x >= this.left && point.x <= this.right && point.y >= this.top && point.y <= this.bottom;
    }

    public boolean contains(RectangleEx rectangleEx) {
        return rectangleEx.left >= this.left && rectangleEx.right <= this.right && rectangleEx.top >= this.top && rectangleEx.bottom <= this.bottom;
    }

    public boolean intersects(RectangleEx rectangleEx) {
        int n = Math.max(rectangleEx.left, this.left);
        int n2 = Math.max(rectangleEx.top, this.top);
        int n3 = Math.min(rectangleEx.right, this.right);
        int n4 = Math.min(rectangleEx.bottom, this.bottom);
        return n3 - n >= 0 && n4 - n2 >= 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RectangleEx)) {
            return false;
        }
        RectangleEx rectangleEx = (RectangleEx)object;
        return this.left == rectangleEx.left && this.right == rectangleEx.right && this.top == rectangleEx.top && this.bottom == rectangleEx.bottom;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("RectangleEx clone not supported", cloneNotSupportedException);
        }
    }

    public RectangleEx limitTo(RectangleEx rectangleEx) {
        if (this.left < rectangleEx.left) {
            this.left = rectangleEx.left;
        }
        if (this.top < rectangleEx.top) {
            this.top = rectangleEx.top;
        }
        if (this.right > rectangleEx.right) {
            this.right = rectangleEx.right;
        }
        if (this.bottom > rectangleEx.bottom) {
            this.bottom = rectangleEx.bottom;
        }
        return this;
    }

    public RectangleEx constrainTo(RectangleEx rectangleEx) {
        int n = this.width();
        int n2 = this.height();
        if (this.left < rectangleEx.left) {
            this.left = rectangleEx.left;
            this.right = this.left + n;
        } else if (this.right > rectangleEx.right) {
            this.right = rectangleEx.right;
            this.left = this.right - n;
        }
        if (this.top < rectangleEx.top) {
            this.top = rectangleEx.top;
            this.bottom = this.top + n2;
        } else if (this.bottom > rectangleEx.bottom) {
            this.bottom = rectangleEx.bottom;
            this.top = this.bottom - n2;
        }
        return this;
    }

    public RectangleEx union(RectangleEx rectangleEx) {
        int n = this.left < rectangleEx.left ? this.left : rectangleEx.left;
        int n2 = this.top < rectangleEx.top ? this.top : rectangleEx.top;
        int n3 = this.right > rectangleEx.right ? this.right : rectangleEx.right;
        int n4 = this.bottom > rectangleEx.bottom ? this.bottom : rectangleEx.bottom;
        return new RectangleEx(n, n2, n3, n4);
    }

    public RectangleEx union(Point point) {
        int n = this.left < point.x ? this.left : point.x;
        int n2 = this.top < point.y ? this.top : point.y;
        int n3 = this.right > point.x ? this.right : point.x;
        int n4 = this.bottom > point.y ? this.bottom : point.y;
        return new RectangleEx(n, n2, n3, n4);
    }
}

