/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.graph;

import com.elixirtech.canvas.graph.GraphVisitor;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelType;
import java.util.Collection;

public class Relationship
extends Node {
    protected RelType m_RelType;
    protected Node m_Origin;
    protected Node m_Destination;

    public Relationship(RelType relType, Node node, Node node2) {
        assert (relType != null);
        assert (node != null);
        assert (node2 != null);
        this.m_RelType = relType;
        this.m_Origin = node;
        this.m_Destination = node2;
    }

    public Relationship() {
    }

    public void setRelType(RelType relType) {
        this.m_RelType = relType;
    }

    public String toString() {
        return String.valueOf(this.m_Origin) + " --" + this.m_RelType.getName() + "-> " + String.valueOf(this.m_Destination);
    }

    public RelType getRelType() {
        assert (this.m_RelType != null);
        return this.m_RelType;
    }

    public Node getOrigin() {
        assert (this.m_Origin != null);
        return this.m_Origin;
    }

    public Node getDestination() {
        assert (this.m_Destination != null);
        return this.m_Destination;
    }

    public void assertRel(Node node, Node node2) {
        this.m_Origin = node;
        this.m_Destination = node2;
        this.connectDestination();
        this.connectSource();
    }

    public void assertRel() {
        this.connectSource();
        this.connectDestination();
    }

    public void remove() {
        this.disconnectSource();
        this.disconnectDestination();
    }

    public void setOrigin(Node node) {
        this.disconnectSource();
        this.m_Origin = node;
        this.connectSource();
    }

    public void setDestination(Node node) {
        this.disconnectDestination();
        this.m_Destination = node;
        this.connectDestination();
    }

    public void originDeleted(Collection<Node> collection) {
        if (!collection.contains(this)) {
            collection.add(this);
            this.disconnectDestination();
            if (this.m_RelType.cascadesDelete()) {
                this.m_Destination.delete(collection);
            }
        }
    }

    public void destinationDeleted(Collection<Node> collection) {
        if (!collection.contains(this)) {
            collection.add(this);
            this.disconnectSource();
        }
    }

    void disconnectSource() {
        if (this.m_Origin != null) {
            this.m_Origin.removeOutwardEdge(this);
        }
    }

    void disconnectDestination() {
        if (this.m_Destination != null) {
            this.m_Destination.removeInwardEdge(this);
        }
    }

    void connectSource() {
        this.m_Origin.addOutwardEdge(this);
    }

    void connectDestination() {
        this.m_Destination.addInwardEdge(this);
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.disconnectSource();
        this.disconnectDestination();
    }

    @Override
    public void reconnect() {
        super.reconnect();
        this.connectSource();
        this.connectDestination();
    }

    @Override
    public void accept(GraphVisitor graphVisitor) {
        boolean bl;
        if (!graphVisitor.visitedRelationship(this) && (bl = graphVisitor.visitRelationship(this))) {
            if (!graphVisitor.visitedNode(this.m_Origin)) {
                this.m_Origin.accept(graphVisitor);
            }
            if (!graphVisitor.visitedNode(this.m_Destination)) {
                this.m_Destination.accept(graphVisitor);
            }
        }
    }
}

