/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.graph;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelCol;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.canvas.graph.Relationship;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TempRelCol
implements RelCol {
    List<Relationship> m_List;
    RelType m_RelType;
    List<Relationship> m_Rels = new ArrayList<Relationship>();
    boolean m_Forward;

    public TempRelCol(RelType relType, List<Relationship> list, boolean bl) {
        assert (relType != null);
        this.m_List = list;
        this.m_RelType = relType;
        this.m_Forward = bl;
        if (this.m_List != null) {
            for (Relationship relationship : this.m_List) {
                if (!relationship.getRelType().equals(this.m_RelType)) continue;
                this.m_Rels.add(relationship);
            }
        }
    }

    @Override
    public boolean isForward() {
        return this.m_Forward;
    }

    @Override
    public int getCount() {
        return this.m_Rels.size();
    }

    @Override
    public Relationship getItem(int n) {
        return this.m_Rels.get(n);
    }

    @Override
    public void move(int n, int n2) {
        Relationship relationship = this.m_Rels.get(n);
        this.m_Rels.remove(n);
        this.m_Rels.add(n2, relationship);
        this.applyChanges();
    }

    @Override
    public List<Relationship> elements() {
        return Collections.unmodifiableList(this.m_Rels);
    }

    @Override
    public RelType getType() {
        return this.m_RelType;
    }

    @Override
    public List<Node> getTargetElements() {
        int n = this.m_Rels.size();
        ArrayList<Node> arrayList = new ArrayList<Node>(n);
        if (this.m_Forward) {
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.m_Rels.get(i).getDestination());
            }
        } else {
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.m_Rels.get(i).getOrigin());
            }
        }
        return arrayList;
    }

    @Override
    public boolean contains(Relationship relationship) {
        return this.m_Rels.contains(relationship);
    }

    @Override
    public void orderRels(int[] nArray) {
        assert (nArray.length == this.m_Rels.size());
        ArrayList<Relationship> arrayList = new ArrayList<Relationship>();
        for (int i = 0; i < nArray.length; ++i) {
            Relationship relationship = this.m_Rels.get(nArray[i]);
            assert (relationship != null);
            this.m_Rels.add(nArray[i], null);
            arrayList.add(relationship);
        }
        this.m_Rels = arrayList;
        this.applyChanges();
    }

    private void applyChanges() {
        assert (this.m_List != null);
        ArrayList<Relationship> arrayList = new ArrayList<Relationship>();
        int n = this.m_List.size();
        for (int i = 0; i < n; ++i) {
            Relationship relationship = this.m_List.get(i);
            if (relationship.getRelType().equals(this.m_RelType)) continue;
            arrayList.add(relationship);
        }
        this.m_List.clear();
        this.m_List.addAll(arrayList);
        this.m_List.addAll(this.m_Rels);
    }
}

