/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.xml;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.Relationship;
import com.elixirtech.jdom.Attribute;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Namespace;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JDOMWriter {
    private Element m_Root;
    private Element m_Current;
    protected List<Node> m_Nodes = new ArrayList<Node>();

    public JDOMWriter() {
        this.m_Root = new Element("graph");
        this.m_Root.setAttribute("version", "1.0");
    }

    public Element getRoot() {
        return this.m_Root;
    }

    public void writeNode(Node node) {
        if (this.m_Nodes.contains(node)) {
            return;
        }
        this.m_Current = new Element("node");
        this.m_Current.setAttribute("id", Integer.toString(this.m_Nodes.size()));
        this.m_Current.setAttribute("class", node.getClass().getName());
        this.m_Nodes.add(node);
        this.writeProperties(node);
        node.writeXMLAnnotations(this.m_Current);
        this.m_Root.addContent(this.m_Current);
        this.writeChildren(node);
    }

    public void close() {
        int n = this.m_Nodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = this.m_Nodes.get(i);
            for (Relationship relationship : node.getOutRelationships()) {
                Node node2 = relationship.getDestination();
                int n2 = this.m_Nodes.indexOf(node2);
                if (n2 < 0) continue;
                this.m_Nodes.add(relationship);
                this.m_Current = new Element("relationship");
                this.m_Current.setAttribute("type", relationship.getRelType().getName());
                this.m_Current.setAttribute("from", Integer.toString(i));
                this.m_Current.setAttribute("to", Integer.toString(n2));
                this.writeProperties(relationship);
                this.m_Root.addContent(this.m_Current);
            }
        }
    }

    protected void writeProperties(Node node) {
        this.writeProperties(node.getProperties(), "property");
        this.writeProperties(node.getUserProperties(), "user-property");
    }

    private void writeProperties(Map<String, String> map, String string) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            Element element = new Element(string);
            element.setAttribute("name", string2);
            Attribute attribute = new Attribute("space", "preserve", Namespace.XML_NAMESPACE);
            element.setAttribute(attribute);
            element.setText(string3);
            this.m_Current.addContent(element);
        }
    }

    protected void writeChildren(Node node) {
        Node[] nodeArray = node.getChildArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            this.writeNode(nodeArray[i]);
        }
    }
}

