/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.data.ChartData;
import com.elixirtech.chart2.data.DataUtil;
import com.elixirtech.chart2.data.ElxCategoryDataset;
import com.elixirtech.chart2.data.FunctionArrayHolder;
import com.elixirtech.chart2.model.ControlSourceList;
import com.elixirtech.chart2.model.ICategoryType;
import com.elixirtech.chart2.model.IGroupSourceProvider;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.RecordScope;
import com.elixirtech.data2.function.First;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.data2.function.RangedFunction;
import com.elixirtech.js.CompiledScript;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import com.elixirtech.report2.data.ControlSourceProcessor;
import com.elixirtech.report2.raw.model.ControlSource;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jfree.data.general.Dataset;
import org.mozilla.javascript.Scriptable;

public class CategoryDatasetAdapter {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CategoryDatasetAdapter.class);
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    public static DatasetHolder getCategoryData(DataTable dataTable, ICategoryType iCategoryType) {
        boolean bl;
        Object[] objectArray;
        int n;
        Object object;
        Object object2;
        Object object3;
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        ElxCategoryDataset elxCategoryDataset = new ElxCategoryDataset(false);
        DatasetHolder datasetHolder = new DatasetHolder((Dataset)elxCategoryDataset);
        DataRecord[] dataRecordArray = dataTable.getRecords();
        DataSchema dataSchema = dataTable.getSchema();
        ControlSource controlSource = iCategoryType.getKeySource();
        ControlSourceList controlSourceList = iCategoryType.getValueSource();
        ControlSource controlSource2 = null;
        if (iCategoryType instanceof IGroupSourceProvider) {
            controlSource2 = ((IGroupSourceProvider)((Object)iCategoryType)).getGroupOnSource();
        }
        int n2 = -1;
        int n3 = -1;
        CompiledScript compiledScript = null;
        Value[] valueArray = new Value[controlSourceList.getControlSourceCount()];
        if ("Field".equals(controlSource.getType())) {
            n2 = dataSchema.getColumnIndex(controlSource.getField());
        } else if ("Script".equals(controlSource.getType())) {
            String string = controlSource.getText();
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            compiledScript = javaScriptEngine.compile("key script", string);
        }
        if (controlSource2 != null) {
            n3 = dataSchema.getColumnIndex(controlSource2.getField());
        }
        for (int i = 0; i < valueArray.length; ++i) {
            IFunctionFactory iFunctionFactory;
            valueArray[i] = new Value();
            object3 = controlSourceList.getControlSource(i);
            valueArray[i].displayName = ((ControlSource)object3).getDisplayNameValue();
            if ("Field".equals(((ControlSource)object3).getType())) {
                valueArray[i].valueIdx = dataSchema.getColumnIndex(((ControlSource)object3).getField());
                continue;
            }
            if ("Operation".equals(((ControlSource)object3).getType())) {
                iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
                valueArray[i].valueIdx = dataSchema.getColumnIndex(((ControlSource)object3).getField());
                object2 = dataSchema.getColumnType(valueArray[i].valueIdx);
                valueArray[i].valueFn = iFunctionFactory.getFunction((DataType)object2, ((ControlSource)object3).getOperation());
                if (!(valueArray[i].valueFn instanceof RangedFunction)) continue;
                object = (RangedFunction)valueArray[i].valueFn;
                dataTable.setRange((RangedFunction)object, dataTable.getGroups(), valueArray[i].valueIdx);
                continue;
            }
            if (!"Script".equals(((ControlSource)object3).getType())) continue;
            iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
            object2 = ((ControlSource)object3).getText();
            if (((String)object2).startsWith("=")) {
                object2 = ((String)object2).substring(1);
            }
            valueArray[i].valueScript = javaScriptEngine.compile("value script", (String)object2);
            valueArray[i].valueFn = iFunctionFactory.getFunction(ControlSourceProcessor.SCRIPT_DATA_TYPE, ((ControlSource)object3).getOperation());
        }
        ChartData chartData = new ChartData(dataTable);
        object3 = DataUtil.createRecordScope(chartData);
        boolean bl2 = false;
        object2 = new HashMap();
        object = new Object[dataRecordArray.length];
        boolean bl3 = n3 >= 0;
        for (n = 0; n < dataRecordArray.length; ++n) {
            Object object4;
            block29: {
                chartData.setRecordIndex(n);
                objectArray = dataRecordArray[n].getData();
                ((RecordScope)((Object)object3)).setData(objectArray);
                object4 = null;
                if (n2 >= 0) {
                    object4 = objectArray[n2];
                } else if (compiledScript != null) {
                    try {
                        object4 = compiledScript.eval((Scriptable)object3);
                    }
                    catch (ScriptException scriptException) {
                        if (bl2) break block29;
                        m_JSLog.warn((Object)("Script error: " + String.valueOf(scriptException)));
                        bl2 = true;
                    }
                }
            }
            if (bl3) {
                datasetHolder.mapKeyToGroup(object4, objectArray[n3]);
            }
            object[n] = object4;
            if (object4 == null) continue;
            FunctionArrayHolder functionArrayHolder = (FunctionArrayHolder)object2.get(object4);
            if (functionArrayHolder == null) {
                Function[] functionArray = new Function[valueArray.length];
                for (int i = 0; i < valueArray.length; ++i) {
                    functionArray[i] = (Function)valueArray[i].valueFn.clone();
                }
                functionArrayHolder = new FunctionArrayHolder(functionArray);
                object2.put(object4, functionArrayHolder);
            }
            for (int i = 0; i < valueArray.length; ++i) {
                Object object5;
                block30: {
                    object5 = null;
                    if (valueArray[i].valueIdx >= 0) {
                        object5 = objectArray[valueArray[i].valueIdx];
                    } else if (valueArray[i].valueScript != null) {
                        try {
                            object5 = valueArray[i].valueScript.eval((Scriptable)object3);
                        }
                        catch (ScriptException scriptException) {
                            if (bl2) break block30;
                            m_JSLog.warn((Object)("Script error: " + String.valueOf(scriptException)));
                            bl2 = true;
                        }
                    }
                }
                functionArrayHolder.update(i, dataRecordArray[n], object5);
            }
        }
        n = iCategoryType.isInverted() && !bl3 ? 1 : 0;
        objectArray = new HashMap();
        boolean bl4 = bl = !iCategoryType.isRetainKeyOrder() && !bl3;
        if (bl) {
            Arrays.sort(object, new SafeComparator());
        }
        for (int i = 0; i < ((Object[])object).length; ++i) {
            Object object6 = object[i];
            FunctionArrayHolder functionArrayHolder = (FunctionArrayHolder)object2.get(object6);
            for (int j = 0; j < valueArray.length; ++j) {
                String string = valueArray[j].displayName;
                Object object7 = functionArrayHolder.getResult(j);
                if (!(object6 instanceof Comparable) || !(object7 instanceof Number)) continue;
                if (n != 0) {
                    elxCategoryDataset.setValue((Number)object7, (Comparable)((Object)string), (Comparable)object6);
                    objectArray.put(string, functionArrayHolder.getRecords());
                    continue;
                }
                elxCategoryDataset.setValue((Number)object7, (Comparable)object6, (Comparable)((Object)string));
                objectArray.put(object6, functionArrayHolder.getRecords());
            }
        }
        datasetHolder.setTitle(DataUtil.buildChartText(javaScriptEngine, dataTable, iCategoryType.getTitle()));
        datasetHolder.setLegend(DataUtil.buildChartText(javaScriptEngine, dataTable, iCategoryType.getLegend()));
        datasetHolder.setReverseMapping((Map)objectArray);
        datasetHolder.setSchema(dataTable.getSchema());
        datasetHolder.setKeyIndex(n2);
        return datasetHolder;
    }

    private static class Value {
        public int valueIdx = -1;
        public String displayName;
        public Function valueFn = new First();
        public CompiledScript valueScript;

        private Value() {
        }
    }

    private static class SafeComparator
    implements Comparator<Object> {
        private SafeComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            return ((Comparable)object).compareTo(object2);
        }
    }
}

