/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.data.ChartData;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.data2.RecordScope;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.data2.function.RangedFunction;
import com.elixirtech.js.BasicScope;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import com.elixirtech.report2.RenderContainer;
import com.elixirtech.report2.data.IDataCacheManager;
import com.elixirtech.report2.js.IProperties;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.IControlSourceHolder;
import com.elixirtech.report2.raw.model.RawReport;
import org.mozilla.javascript.Scriptable;

public class DataUtil {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DataUtil.class);
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buildChartText(JavaScriptEngine javaScriptEngine, DataTable dataTable, IControlSourceHolder iControlSourceHolder) {
        if (iControlSourceHolder == null) {
            return null;
        }
        ControlSource controlSource = iControlSourceHolder.getControlSource();
        if (controlSource == null) {
            return null;
        }
        String string = controlSource.getType();
        if ("Literal".equals(string)) {
            return controlSource.getText();
        }
        if ("Field".equals(string)) {
            DataSchema dataSchema = dataTable.getSchema();
            int n = dataSchema.getColumnIndex(controlSource.getField());
            if (n >= 0 && dataTable.getRecordCount() > 0) {
                return String.valueOf(dataTable.getRecord(0).getData(n));
            }
        } else {
            if ("Operation".equals(string)) {
                DataSchema dataSchema = dataTable.getSchema();
                int n = dataSchema.getColumnIndex(controlSource.getField());
                if (n >= 0) {
                    DataType dataType;
                    IFunctionFactory iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
                    Function function = iFunctionFactory.getFunction(dataType = dataSchema.getColumnType(n), controlSource.getOperation());
                    if (function instanceof RangedFunction && dataTable.getRecordCount() > 0) {
                        RangedFunction rangedFunction = (RangedFunction)function;
                        dataTable.setRange(rangedFunction, dataTable.getGroups(), n);
                        GroupNode groupNode = new GroupNode(0, 0);
                        return String.valueOf(dataTable.apply(function, groupNode, n));
                    }
                    return String.valueOf(dataTable.apply(function, dataTable.getGroups(), n));
                }
                return null;
            }
            if ("Script".equals(string) && dataTable.getRecordCount() > 0) {
                String string2 = null;
                PropertiesImpl propertiesImpl = new PropertiesImpl();
                BasicScope basicScope = new BasicScope();
                basicScope.put("Data", dataTable);
                basicScope.put("Properties", propertiesImpl);
                basicScope.put("Parameters", propertiesImpl);
                javaScriptEngine.pushScope((Scriptable)basicScope);
                try {
                    String string3 = controlSource.getText();
                    string3 = ArgumentMap.substitute(string3, propertiesImpl);
                    if (string3.startsWith("=")) {
                        string3 = string3.substring(1);
                    }
                    string2 = String.valueOf(javaScriptEngine.evaluate("title", string3));
                }
                catch (ScriptException scriptException) {
                    m_JSLog.warn((Object)("Title script exception: " + String.valueOf(scriptException)));
                }
                finally {
                    javaScriptEngine.popScope();
                }
                return string2;
            }
        }
        return null;
    }

    public static RecordScope createRecordScope(ChartData chartData) {
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        DataSchema dataSchema = chartData.getDataTable().getSchema();
        IDataCacheManager iDataCacheManager = RenderContainer.getOrNull(IDataCacheManager.class);
        BasicScope basicScope = new BasicScope();
        basicScope.put("Data", chartData);
        basicScope.put("DataCacheManager", iDataCacheManager, IDataCacheManager.class);
        RecordScope recordScope = new RecordScope(dataSchema);
        recordScope.setParentScope((Scriptable)basicScope);
        basicScope.setParentScope(javaScriptEngine.getScope());
        return recordScope;
    }

    private static class PropertiesImpl
    implements IProperties,
    ArgumentMap.ICallback {
        @Override
        public String get(String string) {
            RawReport rawReport = RenderContainer.getOrNull(RawReport.class);
            return rawReport != null ? rawReport.getProperty(string) : null;
        }

        @Override
        public String getValue(String string, String string2) {
            return this.get(string);
        }

        @Override
        @Deprecated
        public String getProperty(String string) {
            return this.get(string);
        }

        @Deprecated
        public void setProperty(String string, String string2) {
            m_Log.error((Object)"PropertiesImpl.setProperty not implemented");
        }
    }
}

