/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.data.ChartData;
import com.elixirtech.chart2.data.DataUtil;
import com.elixirtech.chart2.data.FunctionArrayHolder;
import com.elixirtech.chart2.model.ControlSourceList;
import com.elixirtech.chart2.model.ICategoryType;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.RecordScope;
import com.elixirtech.data2.function.Collect;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.data2.function.RangedFunction;
import com.elixirtech.js.CompiledScript;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import com.elixirtech.report2.raw.model.ControlSource;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.mozilla.javascript.Scriptable;

public class XYDatasetAdapter {
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    public static DatasetHolder getXYData(DataTable dataTable, ICategoryType iCategoryType) {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        Object object5;
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        DataRecord[] dataRecordArray = dataTable.getRecords();
        DataSchema dataSchema = dataTable.getSchema();
        ControlSource controlSource = iCategoryType.getKeySource();
        ControlSourceList controlSourceList = iCategoryType.getValueSource();
        int n2 = -1;
        CompiledScript compiledScript = null;
        Value[] valueArray = new Value[controlSourceList.getControlSourceCount()];
        if ("Field".equals(controlSource.getType())) {
            n2 = dataSchema.getColumnIndex(controlSource.getField());
        } else if ("Script".equals(controlSource.getType())) {
            String string = controlSource.getText();
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            compiledScript = javaScriptEngine.compile("key script", string);
        }
        for (int i = 0; i < valueArray.length; ++i) {
            Object object6;
            valueArray[i] = new Value();
            object5 = controlSourceList.getControlSource(i);
            valueArray[i].displayName = ((ControlSource)object5).getDisplayNameValue();
            if ("Field".equals(((ControlSource)object5).getType())) {
                valueArray[i].valueIdx = dataSchema.getColumnIndex(((ControlSource)object5).getField());
                continue;
            }
            if ("Operation".equals(((ControlSource)object5).getType())) {
                object6 = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
                valueArray[i].valueIdx = dataSchema.getColumnIndex(((ControlSource)object5).getField());
                object4 = dataSchema.getColumnType(valueArray[i].valueIdx);
                valueArray[i].valueFn = object6.getFunction((DataType)object4, ((ControlSource)object5).getOperation());
                if (!(valueArray[i].valueFn instanceof RangedFunction)) continue;
                RangedFunction rangedFunction = (RangedFunction)valueArray[i].valueFn;
                dataTable.setRange(rangedFunction, dataTable.getGroups(), valueArray[i].valueIdx);
                continue;
            }
            if (!"Script".equals(((ControlSource)object5).getType())) continue;
            object6 = ((ControlSource)object5).getText();
            if (((String)object6).startsWith("=")) {
                object6 = ((String)object6).substring(1);
            }
            valueArray[i].valueScript = javaScriptEngine.compile("value script", (String)object6);
        }
        ChartData chartData = new ChartData(dataTable);
        object5 = DataUtil.createRecordScope(chartData);
        boolean bl = false;
        object4 = new TreeMap<Object, FunctionArrayHolder>();
        for (n = 0; n < dataRecordArray.length; ++n) {
            block22: {
                chartData.setRecordIndex(n);
                object3 = dataRecordArray[n].getData();
                ((RecordScope)((Object)object5)).setData((Object[])object3);
                object2 = null;
                if (n2 >= 0) {
                    object2 = object3[n2];
                } else if (compiledScript != null) {
                    try {
                        object2 = compiledScript.eval((Scriptable)object5);
                    }
                    catch (ScriptException scriptException) {
                        if (bl) break block22;
                        m_JSLog.warn((Object)("Script error: " + String.valueOf(scriptException)));
                        bl = true;
                    }
                }
            }
            if (object2 == null) continue;
            object = (FunctionArrayHolder)object4.get(object2);
            if (object == null) {
                Function[] functionArray = new Function[valueArray.length];
                for (int i = 0; i < valueArray.length; ++i) {
                    functionArray[i] = (Function)valueArray[i].valueFn.clone();
                }
                object = new FunctionArrayHolder(functionArray);
                object4.put(object2, object);
            }
            for (int i = 0; i < valueArray.length; ++i) {
                Object object7;
                block23: {
                    object7 = null;
                    if (valueArray[i].valueIdx >= 0) {
                        object7 = object3[valueArray[i].valueIdx];
                    } else if (valueArray[i].valueScript != null) {
                        try {
                            object7 = valueArray[i].valueScript.eval((Scriptable)object5);
                        }
                        catch (ScriptException scriptException) {
                            if (bl) break block23;
                            m_JSLog.warn((Object)("Script error: " + String.valueOf(scriptException)));
                            bl = true;
                        }
                    }
                }
                ((FunctionArrayHolder)object).update(i, dataRecordArray[n], object7);
            }
        }
        n = n2 >= 0 ? (DataType.DATE == (object3 = dataSchema.getColumnType(n2)) || DataType.TIME == object3 || DataType.TIMESTAMP == object3 ? 1 : 0) : (int)(XYDatasetAdapter.allDates(object4.keySet()) ? 1 : 0);
        object3 = new HashMap();
        object2 = n != 0 ? XYDatasetAdapter.processTimeSeries(valueArray, object4, (Map<Object, DataRecord[]>)object3) : XYDatasetAdapter.processNumberSeries(valueArray, object4, (Map<Object, DataRecord[]>)object3);
        object = new DatasetHolder((Dataset)object2);
        ((DatasetHolder)object).setTitle(DataUtil.buildChartText(javaScriptEngine, dataTable, iCategoryType.getTitle()));
        ((DatasetHolder)object).setLegend(DataUtil.buildChartText(javaScriptEngine, dataTable, iCategoryType.getLegend()));
        ((DatasetHolder)object).setReverseMapping((Map)object3);
        ((DatasetHolder)object).setSchema(dataTable.getSchema());
        ((DatasetHolder)object).setKeyIndex(n2);
        return object;
    }

    private static Dataset processNumberSeries(Value[] valueArray, Map<Object, FunctionArrayHolder> map, Map<Object, DataRecord[]> map2) {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        XYSeries[] xYSeriesArray = new XYSeries[valueArray.length];
        for (int i = 0; i < xYSeriesArray.length; ++i) {
            xYSeriesArray[i] = new XYSeries((Comparable)((Object)valueArray[i].displayName));
            xYSeriesCollection.addSeries(xYSeriesArray[i]);
        }
        for (Object object : map.keySet()) {
            FunctionArrayHolder functionArrayHolder = map.get(object);
            for (int i = 0; i < valueArray.length; ++i) {
                Object object2 = functionArrayHolder.getResult(i);
                if (object instanceof Date) {
                    object = ((Date)object).getTime();
                }
                if (object instanceof Number && object2 instanceof Number) {
                    xYSeriesArray[i].add((Number)object, (Number)object2);
                    map2.put(object, functionArrayHolder.getRecords());
                    continue;
                }
                if (!(object instanceof Number) || !(object2 instanceof List)) continue;
                Number number = (Number)object;
                for (Object e : (List)object2) {
                    if (!(e instanceof Number)) continue;
                    xYSeriesArray[i].add(number, (Number)e);
                    map2.put(number, functionArrayHolder.getRecords());
                }
            }
        }
        XYSeriesCollection xYSeriesCollection2 = xYSeriesCollection;
        return xYSeriesCollection2;
    }

    private static Dataset processTimeSeries(Value[] valueArray, Map<Object, FunctionArrayHolder> map, Map<Object, DataRecord[]> map2) {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        TimeSeries[] timeSeriesArray = new TimeSeries[valueArray.length];
        for (int i = 0; i < timeSeriesArray.length; ++i) {
            timeSeriesArray[i] = new TimeSeries((Comparable)((Object)valueArray[i].displayName), FixedMillisecond.class);
            timeSeriesCollection.addSeries(timeSeriesArray[i]);
        }
        for (Object object : map.keySet()) {
            if (!(object instanceof Date)) continue;
            FixedMillisecond fixedMillisecond = new FixedMillisecond((Date)object);
            FunctionArrayHolder functionArrayHolder = map.get(object);
            for (int i = 0; i < valueArray.length; ++i) {
                Object object2 = functionArrayHolder.getResult(i);
                if (object2 instanceof List) {
                    List list = (List)object2;
                    object2 = list.size() == 1 ? list.get(0) : XYDatasetAdapter.average(list);
                }
                if (!(object2 instanceof Number)) continue;
                timeSeriesArray[i].add((RegularTimePeriod)fixedMillisecond, (Number)object2);
                map2.put(object, functionArrayHolder.getRecords());
            }
        }
        TimeSeriesCollection timeSeriesCollection2 = timeSeriesCollection;
        return timeSeriesCollection2;
    }

    private static Object average(List<?> list) {
        if (list.size() == 0) {
            return null;
        }
        double d = 0.0;
        int n = 0;
        for (Object obj : list) {
            if (!(obj instanceof Number)) continue;
            d += ((Number)obj).doubleValue();
            ++n;
        }
        if (n == 0) {
            return null;
        }
        return d / (double)n;
    }

    private static boolean allDates(Set<?> set) {
        for (Object obj : set) {
            if (obj instanceof Date) continue;
            return false;
        }
        return true;
    }

    private static class Value {
        public int valueIdx = -1;
        public String displayName;
        public Function valueFn = new Collect();
        public CompiledScript valueScript;

        private Value() {
        }
    }
}

