/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.chart2.model.Font;
import com.elixirtech.chart2.model.Format;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Label;
import com.elixirtech.chart2.model.Tick;
import com.elixirtech.chart2.renderer.AbstractChartRenderer;
import com.elixirtech.chart2.renderer.Formatter;
import com.elixirtech.chart2.renderer.IElxCategoryPlot;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.NumberFormat;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;

public abstract class Abstract2DChartRenderer
extends AbstractChartRenderer {
    public Abstract2DChartRenderer(IChart iChart) {
        super(iChart);
    }

    protected void setRangeAxis(IElxCategoryPlot iElxCategoryPlot, com.elixirtech.chart2.model.Axis axis) {
        if (axis == null) {
            return;
        }
        ValueAxis valueAxis = iElxCategoryPlot.getRangeAxis();
        if (valueAxis == null) {
            return;
        }
        this.formatTick((Axis)valueAxis, axis.getTick());
        this.formatLabel((Axis)valueAxis, axis.getLabel());
    }

    protected void setDomainAxis(IElxCategoryPlot iElxCategoryPlot, com.elixirtech.chart2.model.Axis axis) {
        if (axis == null) {
            return;
        }
        CategoryAxis categoryAxis = iElxCategoryPlot.getDomainAxis();
        Tick tick = axis.getTick();
        double d = tick.getLabelAngle();
        if (d != 0.0) {
            if ("down".equals(tick.getLabelRotation())) {
                if (d == 1.5707963267948966) {
                    categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
                } else if (d == 0.7853981633974483) {
                    categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
                } else {
                    categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.createDownRotationLabelPositions((double)d));
                }
            } else if (d == 1.5707963267948966) {
                categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            } else if (d == 0.7853981633974483) {
                categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
            } else {
                categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)d));
            }
        } else {
            categoryAxis.setMaximumCategoryLabelLines(4);
        }
        this.formatTick((Axis)categoryAxis, axis.getTick());
        this.formatLabel((Axis)categoryAxis, axis.getLabel());
        Format format = (Format)axis.getTick().getFormat();
        iElxCategoryPlot.setCategoryFormat(format, Abstract2DChartRenderer.getLocale(this.m_Chart, format));
    }

    protected void setRangeAxis(XYPlot xYPlot, com.elixirtech.chart2.model.Axis axis) {
        if (axis == null) {
            return;
        }
        ValueAxis valueAxis = xYPlot.getRangeAxis();
        double d = axis.getTick().getLabelAngle();
        valueAxis.setVerticalTickLabels(d != 0.0);
        this.formatTick((Axis)valueAxis, axis.getTick());
        this.formatLabel((Axis)valueAxis, axis.getLabel());
    }

    protected void setDomainAxis(XYPlot xYPlot, com.elixirtech.chart2.model.Axis axis) {
        if (axis == null) {
            return;
        }
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        double d = axis.getTick().getLabelAngle();
        valueAxis.setVerticalTickLabels(d != 0.0);
        this.formatTick((Axis)valueAxis, axis.getTick());
        this.formatLabel((Axis)valueAxis, axis.getLabel());
    }

    protected void formatTick(Axis axis, Tick tick) {
        if (tick.isTickMarkVisible()) {
            Font font;
            if (axis instanceof ValueAxis) {
                this.formatValueAxis((ValueAxis)axis, (Format)tick.getFormat());
            }
            if ((font = tick.getFont()) != null && font.getFontFamily() != null) {
                axis.setTickLabelFont(font.getAWTFont());
                axis.setTickLabelPaint((Paint)StandardColor.lookup(font.getFontColor(), Color.BLACK));
            }
        } else {
            axis.setTickMarksVisible(false);
            axis.setTickLabelsVisible(false);
        }
    }

    protected void formatLabel(Axis axis, Label label) {
        if (StringUtil.notEmpty(label.getText())) {
            axis.setLabel(label.getText());
            Font font = label.getFont();
            if (font != null && font.getFontFamily() != null) {
                axis.setLabelFont(font.getAWTFont());
                axis.setLabelPaint((Paint)StandardColor.lookup(font.getFontColor(), Color.BLACK));
            }
        }
    }

    private void formatValueAxis(ValueAxis valueAxis, Format format) {
        if (Formatter.notNone(format)) {
            if (valueAxis instanceof NumberAxis) {
                NumberAxis numberAxis = (NumberAxis)valueAxis;
                NumberFormat numberFormat = Formatter.buildNumberFormatter(format, Abstract2DChartRenderer.getLocale(this.m_Chart, format));
                numberAxis.setNumberFormatOverride(numberFormat);
            } else if (valueAxis instanceof DateAxis) {
                DateAxis dateAxis = (DateAxis)valueAxis;
                DateFormat dateFormat = (DateFormat)Formatter.buildFormatter(format, Abstract2DChartRenderer.getLocale(this.m_Chart, format));
                dateAxis.setDateFormatOverride(dateFormat);
            }
        }
    }
}

