/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.model.CompositeChart;
import com.elixirtech.chart2.model.CompositeChartType;
import com.elixirtech.chart2.model.CompositeChartUi;
import com.elixirtech.chart2.model.Format;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Legend;
import com.elixirtech.chart2.model.SubPlot;
import com.elixirtech.chart2.model.Title;
import com.elixirtech.chart2.renderer.Abstract2DChartRenderer;
import com.elixirtech.chart2.renderer.CategoryRenderer;
import com.elixirtech.chart2.renderer.ChartRenderFactory;
import com.elixirtech.chart2.renderer.CompositeChartWrapper;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.renderer.DatasetHolders;
import com.elixirtech.chart2.renderer.ElxCategoryPlot;
import com.elixirtech.chart2.renderer.Formatter;
import com.elixirtech.chart2.renderer.IElxCategoryPlot;
import com.elixirtech.chart2.renderer.XYRenderer;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Paint;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeCategoryPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;

public class ComboChartRenderer
extends Abstract2DChartRenderer {
    protected CompositeChart m_CompositeChart;

    public ComboChartRenderer(IChart iChart) {
        super(iChart);
        this.m_CompositeChart = (CompositeChart)iChart;
        assert (this.m_CompositeChart.getCategory().equals("Combo"));
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolders datasetHolders) throws ChartException {
        IElxCategoryPlot iElxCategoryPlot;
        Object object2 = null;
        CompositeChartType compositeChartType = (CompositeChartType)this.m_CompositeChart.getChartType();
        assert (compositeChartType != null);
        CompositeChartUi compositeChartUi = compositeChartType.getCompositeChartUi();
        if (this.m_CompositeChart.getType().endsWith("CategoryPlot")) {
            iElxCategoryPlot = (IElxCategoryPlot)this.getCategoryPlot(object, datasetHolders);
            if (iElxCategoryPlot != null) {
                this.setDomainAxis(iElxCategoryPlot, compositeChartUi.getKeyAxis());
                this.setRangeAxis(iElxCategoryPlot, compositeChartUi.getValueAxis());
                object2 = (Plot)iElxCategoryPlot;
            }
        } else if (this.m_CompositeChart.getType().endsWith("XYPlot")) {
            iElxCategoryPlot = (XYPlot)this.getXYPlot(object, datasetHolders);
            if (iElxCategoryPlot != null) {
                this.setDomainAxis((XYPlot)iElxCategoryPlot, compositeChartUi.getKeyAxis());
                this.setRangeAxis((XYPlot)iElxCategoryPlot, compositeChartUi.getValueAxis());
                object2 = iElxCategoryPlot;
            }
        } else {
            throw new ChartException("Chart Type not supported: " + this.m_CompositeChart.getType());
        }
        iElxCategoryPlot = null;
        iElxCategoryPlot = object2 == null ? new JFreeChart((Plot)new CategoryPlot()) : new JFreeChart(object2);
        Title title = compositeChartType.getTitle();
        Legend legend = compositeChartType.getLegend();
        ComboChartRenderer.setTitle((JFreeChart)iElxCategoryPlot, title, datasetHolders.getTitle());
        ComboChartRenderer.setLegend((JFreeChart)iElxCategoryPlot, legend, datasetHolders.getLegend());
        iElxCategoryPlot.setBackgroundPaint(this.m_Chart.getBackgroundColor());
        ComboChartRenderer.processScript(object, (JFreeChart)iElxCategoryPlot, this.m_Chart.getOnConfigure());
        return iElxCategoryPlot;
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        throw new ChartException("Not to be used");
    }

    private CategoryPlot getCategoryPlot(Object object, DatasetHolders datasetHolders) throws ChartException {
        int n = this.m_CompositeChart.getSubPlotCount();
        if (n < 1) {
            return null;
        }
        ArrayList<CatePlotInfo> arrayList = new ArrayList<CatePlotInfo>();
        CompositeChartType compositeChartType = (CompositeChartType)this.m_CompositeChart.getChartType();
        String string = this.m_CompositeChart.getDomainRangeType();
        CompositeChartUi compositeChartUi = compositeChartType.getCompositeChartUi();
        for (int i = 0; i < n; ++i) {
            SubPlot subPlot = this.m_CompositeChart.getSubPlot(i);
            if (!subPlot.isEnabled()) continue;
            CategoryRenderer categoryRenderer = (CategoryRenderer)ChartRenderFactory.getRenderer(new CompositeChartWrapper(this.m_CompositeChart, subPlot));
            DatasetHolder datasetHolder = datasetHolders.getDataholder(i);
            ElxCategoryPlot elxCategoryPlot = categoryRenderer.getPlot(object, datasetHolder);
            this.setDomainAxis(elxCategoryPlot, compositeChartUi.getKeyAxis());
            this.setRangeAxis(elxCategoryPlot, compositeChartUi.getValueAxis());
            arrayList.add(new CatePlotInfo(elxCategoryPlot, subPlot.getWeight()));
            String string2 = subPlot.getName();
            if (!StringUtil.isEmpty(string2)) {
                if (!"Domain".equals(string)) {
                    elxCategoryPlot.getDomainAxis().setLabel(string2);
                } else {
                    elxCategoryPlot.getRangeAxis().setLabel(string2);
                }
            }
            CategoryRenderer.setValue(this.m_CompositeChart, elxCategoryPlot, compositeChartUi);
            elxCategoryPlot.setBackgroundPaint(StandardColor.lookup(compositeChartUi.getPlotBackground(), (Color)null));
            elxCategoryPlot.setDomainGridlinesVisible(compositeChartUi.isDomainGridlinesVisible());
            elxCategoryPlot.setRangeGridlinesVisible(compositeChartUi.isRangeGridlinesVisible());
        }
        CombinedDomainCategoryPlot combinedDomainCategoryPlot = null;
        if ("Domain".equals(string)) {
            combinedDomainCategoryPlot = this.getCategoryDomainSubPlots(arrayList);
        } else if ("Range".equals(string)) {
            combinedDomainCategoryPlot = this.getCategoryRangeSubPlots(arrayList);
        } else {
            throw new ChartException("No valid Category range or domain axis type set!");
        }
        combinedDomainCategoryPlot.setRangeAxis((ValueAxis)new NumberAxis());
        combinedDomainCategoryPlot.setDomainAxis(new CategoryAxis());
        return combinedDomainCategoryPlot;
    }

    private CombinedDomainCategoryPlot getCategoryDomainSubPlots(ArrayList<CatePlotInfo> arrayList) {
        ElxCombinedDomainCategoryPlot elxCombinedDomainCategoryPlot = new ElxCombinedDomainCategoryPlot();
        Double d = this.m_CompositeChart.getSubPlotGap();
        if (d != null && d >= 0.0) {
            elxCombinedDomainCategoryPlot.setGap(d);
        }
        for (CatePlotInfo catePlotInfo : arrayList) {
            elxCombinedDomainCategoryPlot.add(catePlotInfo.m_Plot, catePlotInfo.m_Weight);
        }
        return elxCombinedDomainCategoryPlot;
    }

    private CombinedRangeCategoryPlot getCategoryRangeSubPlots(ArrayList<CatePlotInfo> arrayList) {
        ElxCombinedRangeCategoryPlot elxCombinedRangeCategoryPlot = new ElxCombinedRangeCategoryPlot();
        Double d = this.m_CompositeChart.getSubPlotGap();
        if (d != null && d >= 0.0) {
            elxCombinedRangeCategoryPlot.setGap(d);
        }
        for (CatePlotInfo catePlotInfo : arrayList) {
            elxCombinedRangeCategoryPlot.add(catePlotInfo.m_Plot, catePlotInfo.m_Weight);
        }
        return elxCombinedRangeCategoryPlot;
    }

    private Plot getXYPlot(Object object, DatasetHolders datasetHolders) throws ChartException {
        int n = this.m_CompositeChart.getSubPlotCount();
        if (n < 1) {
            throw new ChartException("Need more than one chart definition.");
        }
        ArrayList<XYPlotInfo> arrayList = new ArrayList<XYPlotInfo>();
        CompositeChartType compositeChartType = (CompositeChartType)this.m_CompositeChart.getChartType();
        CompositeChartUi compositeChartUi = compositeChartType.getCompositeChartUi();
        String string = this.m_CompositeChart.getDomainRangeType();
        ValueAxis valueAxis = null;
        ValueAxis valueAxis2 = null;
        for (int i = 0; i < n; ++i) {
            SubPlot subPlot = this.m_CompositeChart.getSubPlot(i);
            if (!subPlot.isEnabled()) continue;
            XYRenderer xYRenderer = (XYRenderer)ChartRenderFactory.getRenderer(new CompositeChartWrapper(this.m_CompositeChart, subPlot));
            DatasetHolder datasetHolder = datasetHolders.getDataholder(i);
            XYPlot xYPlot = xYRenderer.getPlot(object, datasetHolder);
            super.setDomainAxis(xYPlot, compositeChartUi.getKeyAxis());
            super.setRangeAxis(xYPlot, compositeChartUi.getValueAxis());
            String string2 = subPlot.getName();
            if (!StringUtil.isEmpty(string2)) {
                if (!"Domain".equals(string)) {
                    xYPlot.getDomainAxis().setLabel(string2);
                } else {
                    xYPlot.getRangeAxis().setLabel(string2);
                }
            }
            xYPlot.setBackgroundPaint((Paint)StandardColor.lookup(compositeChartUi.getPlotBackground(), (Color)null));
            valueAxis = xYPlot.getDomainAxis();
            valueAxis2 = xYPlot.getRangeAxis();
            arrayList.add(new XYPlotInfo(xYPlot, subPlot.getWeight()));
            XYRenderer.setValue(xYRenderer, this.m_CompositeChart, xYPlot, compositeChartUi.getValue(), compositeChartUi.getPositivePosition(), compositeChartUi.getNegativePosition());
            xYPlot.setDomainGridlinesVisible(compositeChartUi.isDomainGridlinesVisible());
            xYPlot.setRangeGridlinesVisible(compositeChartUi.isRangeGridlinesVisible());
        }
        XYPlot xYPlot = null;
        if ("Domain".equals(this.m_CompositeChart.getDomainRangeType())) {
            xYPlot = this.getXYDomainSubPlots(arrayList, valueAxis);
            xYPlot.setRangeAxis(valueAxis2);
        } else if ("Range".equals(this.m_CompositeChart.getDomainRangeType())) {
            xYPlot = this.getXYRangeSubPlots(arrayList, valueAxis2);
            xYPlot.setDomainAxis(valueAxis);
        } else {
            throw new ChartException("No valid XY range or domain axis type set!");
        }
        return xYPlot;
    }

    private XYPlot getXYDomainSubPlots(ArrayList<XYPlotInfo> arrayList, ValueAxis valueAxis) {
        CombinedDomainXYPlot combinedDomainXYPlot = new CombinedDomainXYPlot(valueAxis);
        Double d = this.m_CompositeChart.getSubPlotGap();
        if (d != null && d >= 0.0) {
            combinedDomainXYPlot.setGap(d.doubleValue());
        }
        for (XYPlotInfo xYPlotInfo : arrayList) {
            combinedDomainXYPlot.add(xYPlotInfo.m_Plot, xYPlotInfo.m_Weight);
        }
        return combinedDomainXYPlot;
    }

    private XYPlot getXYRangeSubPlots(ArrayList<XYPlotInfo> arrayList, ValueAxis valueAxis) {
        CombinedRangeXYPlot combinedRangeXYPlot = new CombinedRangeXYPlot(valueAxis);
        Double d = this.m_CompositeChart.getSubPlotGap();
        if (d != null && d >= 0.0) {
            combinedRangeXYPlot.setGap(d.doubleValue());
        }
        for (XYPlotInfo xYPlotInfo : arrayList) {
            combinedRangeXYPlot.add(xYPlotInfo.m_Plot, xYPlotInfo.m_Weight);
        }
        return combinedRangeXYPlot;
    }

    static class CatePlotInfo {
        public ElxCategoryPlot m_Plot;
        public int m_Weight;

        public CatePlotInfo(ElxCategoryPlot elxCategoryPlot, int n) {
            this.m_Plot = elxCategoryPlot;
            this.m_Weight = n;
        }
    }

    static class ElxCombinedDomainCategoryPlot
    extends CombinedDomainCategoryPlot
    implements IElxCategoryPlot {
        private Format m_Format;
        private Locale m_Locale;

        @Override
        public List<?> getCategoriesForAxis(CategoryAxis categoryAxis) {
            boolean bl;
            List list = super.getCategoriesForAxis(categoryAxis);
            boolean bl2 = bl = !"None".equals(this.m_Format.getType());
            if (bl) {
                NumberFormat numberFormat = Formatter.buildNumberFormatter(this.m_Format, this.m_Locale);
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Object e = list.get(i);
                    if (!(e instanceof Number)) continue;
                    list.set(i, numberFormat.format(e));
                }
            }
            return list;
        }

        @Override
        public void setCategoryFormat(Format format, Locale locale) {
            this.m_Format = format;
            this.m_Locale = locale;
        }
    }

    static class ElxCombinedRangeCategoryPlot
    extends CombinedRangeCategoryPlot
    implements IElxCategoryPlot {
        private Format m_Format;
        private Locale m_Locale;

        @Override
        public List<?> getCategoriesForAxis(CategoryAxis categoryAxis) {
            boolean bl;
            List list = super.getCategoriesForAxis(categoryAxis);
            boolean bl2 = bl = !"None".equals(this.m_Format.getType());
            if (bl) {
                NumberFormat numberFormat = Formatter.buildNumberFormatter(this.m_Format, this.m_Locale);
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Object e = list.get(i);
                    if (!(e instanceof Number)) continue;
                    list.set(i, numberFormat.format(e));
                }
            }
            return list;
        }

        @Override
        public void setCategoryFormat(Format format, Locale locale) {
            this.m_Format = format;
            this.m_Locale = locale;
        }
    }

    static class XYPlotInfo {
        public XYPlot m_Plot;
        public int m_Weight;

        public XYPlotInfo(XYPlot xYPlot, int n) {
            this.m_Plot = xYPlot;
            this.m_Weight = n;
        }
    }
}

