/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.model.GanttTaskType;
import com.elixirtech.chart2.model.GanttTaskUi;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.renderer.Abstract2DChartRenderer;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.renderer.ElxCategoryPlot;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.IntervalCategoryToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;

public class GanttRenderer
extends Abstract2DChartRenderer {
    private GanttTaskType m_ChartType;

    public GanttRenderer(IChart iChart) {
        super(iChart);
        this.m_ChartType = (GanttTaskType)iChart.getChartType();
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        GanttTaskUi ganttTaskUi = this.m_ChartType.getGanttTaskUi();
        CategoryAxis categoryAxis = new CategoryAxis();
        DateAxis dateAxis = new DateAxis();
        org.jfree.chart.renderer.category.GanttRenderer ganttRenderer = new org.jfree.chart.renderer.category.GanttRenderer();
        ganttRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new IntervalCategoryToolTipGenerator("{3} - {4}", DateFormat.getDateInstance()));
        ElxCategoryPlot elxCategoryPlot = new ElxCategoryPlot((CategoryDataset)datasetHolder.getDataset(), categoryAxis, (ValueAxis)dateAxis, (CategoryItemRenderer)ganttRenderer);
        elxCategoryPlot.setOrientation(PlotOrientation.HORIZONTAL);
        this.setRangeAxis(elxCategoryPlot, ganttTaskUi.getValueAxis());
        this.setDomainAxis(elxCategoryPlot, ganttTaskUi.getKeyAxis());
        elxCategoryPlot.setDomainGridlinesVisible(ganttTaskUi.isDomainGridlinesVisible());
        elxCategoryPlot.setRangeGridlinesVisible(ganttTaskUi.isRangeGridlinesVisible());
        elxCategoryPlot.setBackgroundPaint(StandardColor.lookup(ganttTaskUi.getPlotBackground(), (Color)null));
        JFreeChart jFreeChart = new JFreeChart((Plot)elxCategoryPlot);
        GanttRenderer.setLegend(jFreeChart, this.m_ChartType.getLegend(), datasetHolder.getLegend());
        GanttRenderer.setTitle(jFreeChart, this.m_ChartType.getTitle(), datasetHolder.getTitle());
        jFreeChart.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        GanttRenderer.processScript(object, jFreeChart, this.m_Chart.getOnConfigure());
        return jFreeChart;
    }
}

