/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.model.Axis;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.CompositeChart;
import com.elixirtech.chart2.model.CompositeChartType;
import com.elixirtech.chart2.model.CompositeChartUi;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Legend;
import com.elixirtech.chart2.model.SubPlot;
import com.elixirtech.chart2.model.Title;
import com.elixirtech.chart2.renderer.Abstract2DChartRenderer;
import com.elixirtech.chart2.renderer.CategoryRenderer;
import com.elixirtech.chart2.renderer.ChartRenderFactory;
import com.elixirtech.chart2.renderer.CompositeChartWrapper;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.renderer.DatasetHolders;
import com.elixirtech.chart2.renderer.ElxCategoryPlot;
import com.elixirtech.chart2.renderer.XYRenderer;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.xy.XYDataset;

public class MultiAxisChartRenderer
extends Abstract2DChartRenderer {
    public static final String AXIS_TOP_OR_LEFT = "top_or_left";
    public static final String AXIS_TOP_OR_RIGHT = "top_or_right";
    public static final String AXIS_BOTTOM_OR_LEFT = "bottom_or_left";
    public static final String AXIS_BOTTOM_OR_RIGHT = "bottom_or_right";
    protected CompositeChart m_CompositeChart;

    protected static AxisLocation getAxisLocation(String string) {
        if (AXIS_TOP_OR_LEFT.equals(string)) {
            return AxisLocation.TOP_OR_LEFT;
        }
        if (AXIS_TOP_OR_RIGHT.equals(string)) {
            return AxisLocation.TOP_OR_RIGHT;
        }
        if (AXIS_BOTTOM_OR_LEFT.equals(string)) {
            return AxisLocation.BOTTOM_OR_LEFT;
        }
        return AxisLocation.BOTTOM_OR_RIGHT;
    }

    public MultiAxisChartRenderer(IChart iChart) {
        super(iChart);
        this.m_CompositeChart = (CompositeChart)iChart;
        assert (this.m_CompositeChart.getCategory().equals("MultiAxis"));
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        throw new ChartException("Not in used");
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolders datasetHolders) throws ChartException {
        Plot plot = null;
        if (this.m_CompositeChart.getType().endsWith("CategoryPlot")) {
            plot = this.getCategoryPlot(object, datasetHolders);
        } else if (this.m_CompositeChart.getType().endsWith("XYPlot")) {
            plot = this.getXYPlot(object, datasetHolders);
        } else {
            throw new ChartException("Chart Type not supported: " + this.m_CompositeChart.getType());
        }
        JFreeChart jFreeChart = null;
        jFreeChart = plot == null ? new JFreeChart((Plot)new CategoryPlot()) : new JFreeChart(plot);
        ChartType chartType = this.m_CompositeChart.getChartType();
        assert (chartType != null);
        Title title = chartType.getTitle();
        Legend legend = chartType.getLegend();
        MultiAxisChartRenderer.setTitle(jFreeChart, title, datasetHolders.getTitle());
        MultiAxisChartRenderer.setLegend(jFreeChart, legend, datasetHolders.getLegend());
        jFreeChart.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        MultiAxisChartRenderer.processScript(object, jFreeChart, this.m_Chart.getOnConfigure());
        return jFreeChart;
    }

    private Plot getCategoryPlot(Object object, DatasetHolders datasetHolders) throws ChartException {
        int n = this.m_CompositeChart.getSubPlotCount();
        if (n < 1) {
            return null;
        }
        ElxCategoryPlot elxCategoryPlot = new ElxCategoryPlot();
        CompositeChartType compositeChartType = (CompositeChartType)this.m_CompositeChart.getChartType();
        CompositeChartUi compositeChartUi = compositeChartType.getCompositeChartUi();
        String string = this.m_CompositeChart.getDomainRangeType();
        assert (string != null);
        elxCategoryPlot.setDomainGridlinesVisible(compositeChartUi.isDomainGridlinesVisible());
        elxCategoryPlot.setRangeGridlinesVisible(compositeChartUi.isRangeGridlinesVisible());
        this.mapCategoryAxis(string, object, datasetHolders, n, elxCategoryPlot, compositeChartType, compositeChartUi);
        return elxCategoryPlot;
    }

    private void mapCategoryAxis(String string, Object object, DatasetHolders datasetHolders, int n, ElxCategoryPlot elxCategoryPlot, CompositeChartType compositeChartType, CompositeChartUi compositeChartUi) throws ChartException {
        boolean bl = "Domain".equals(string);
        Axis axis = null;
        if (bl) {
            axis = compositeChartUi.getValueAxis();
            elxCategoryPlot.setDomainAxis(new CategoryAxis());
            this.setDomainAxis(elxCategoryPlot, compositeChartUi.getKeyAxis());
        } else {
            elxCategoryPlot.setRangeAxis((ValueAxis)new NumberAxis());
            this.setRangeAxis(elxCategoryPlot, compositeChartUi.getValueAxis());
            axis = compositeChartUi.getKeyAxis();
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            SubPlot subPlot = this.m_CompositeChart.getSubPlot(i);
            if (!subPlot.isEnabled()) continue;
            CategoryRenderer categoryRenderer = (CategoryRenderer)ChartRenderFactory.getRenderer(new CompositeChartWrapper(this.m_CompositeChart, subPlot));
            DatasetHolder datasetHolder = datasetHolders.getDataholder(i);
            ElxCategoryPlot elxCategoryPlot2 = categoryRenderer.getPlot(object, datasetHolder);
            String string2 = subPlot.getName();
            String string3 = axis.getLabel().getText();
            if (StringUtil.notEmpty(string2)) {
                axis.getLabel().setText(string2);
            }
            elxCategoryPlot.setDataset(n2, (CategoryDataset)datasetHolders.getDataholder(i).getDataset());
            if (bl) {
                this.setRangeAxis(elxCategoryPlot2, axis);
                elxCategoryPlot.setRangeAxis(n2, elxCategoryPlot2.getRangeAxis());
                elxCategoryPlot.setRangeAxisLocation(n2, MultiAxisChartRenderer.getAxisLocation(subPlot.getAxisLocation()));
                elxCategoryPlot.mapDatasetToRangeAxis(n2, n2);
            } else {
                this.setDomainAxis(elxCategoryPlot2, axis);
                elxCategoryPlot.setDomainAxis(n2, elxCategoryPlot2.getDomainAxis());
                elxCategoryPlot.setDomainAxisLocation(n2, MultiAxisChartRenderer.getAxisLocation(subPlot.getAxisLocation()));
                elxCategoryPlot.mapDatasetToDomainAxis(n2, n2);
            }
            axis.getLabel().setText(string3);
            elxCategoryPlot.setBackgroundPaint(StandardColor.lookup(compositeChartUi.getPlotBackground(), (Color)null));
            elxCategoryPlot.setRenderer(n2, elxCategoryPlot2.getRenderer());
            CategoryRenderer.setValue(this.m_CompositeChart, elxCategoryPlot2, compositeChartUi);
            ++n2;
        }
    }

    private Plot getXYPlot(Object object, DatasetHolders datasetHolders) throws ChartException {
        int n = this.m_CompositeChart.getSubPlotCount();
        if (n < 1) {
            return null;
        }
        XYPlot xYPlot = new XYPlot();
        CompositeChartType compositeChartType = (CompositeChartType)this.m_CompositeChart.getChartType();
        CompositeChartUi compositeChartUi = compositeChartType.getCompositeChartUi();
        String string = this.m_CompositeChart.getDomainRangeType();
        xYPlot.setDomainGridlinesVisible(compositeChartUi.isDomainGridlinesVisible());
        xYPlot.setRangeGridlinesVisible(compositeChartUi.isRangeGridlinesVisible());
        assert (string != null);
        this.mapXYAxis(string, object, datasetHolders, n, xYPlot, compositeChartType, compositeChartUi);
        return xYPlot;
    }

    private void mapXYAxis(String string, Object object, DatasetHolders datasetHolders, int n, XYPlot xYPlot, CompositeChartType compositeChartType, CompositeChartUi compositeChartUi) throws ChartException {
        boolean bl = "Domain".equals(string);
        Axis axis = null;
        if (bl) {
            xYPlot.setDomainAxis((ValueAxis)new NumberAxis());
            this.setDomainAxis(xYPlot, compositeChartUi.getKeyAxis());
            axis = compositeChartUi.getValueAxis();
        } else {
            xYPlot.setRangeAxis((ValueAxis)new NumberAxis());
            this.setRangeAxis(xYPlot, compositeChartUi.getValueAxis());
            axis = compositeChartUi.getKeyAxis();
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            SubPlot subPlot = this.m_CompositeChart.getSubPlot(i);
            if (subPlot.isEnabled()) {
                XYRenderer xYRenderer = (XYRenderer)ChartRenderFactory.getRenderer(new CompositeChartWrapper(this.m_CompositeChart, subPlot));
                DatasetHolder datasetHolder = datasetHolders.getDataholder(i);
                XYPlot xYPlot2 = xYRenderer.getPlot(object, datasetHolder);
                String string2 = subPlot.getName();
                String string3 = axis.getLabel().getText();
                if (StringUtil.notEmpty(string2)) {
                    axis.getLabel().setText(string2);
                }
                xYPlot.setDataset(n2, (XYDataset)datasetHolder.getDataset());
                if (bl) {
                    this.setRangeAxis(xYPlot2, axis);
                    xYPlot.setRangeAxis(n2, xYPlot2.getRangeAxis());
                    xYPlot.setDomainAxis(n2, xYPlot2.getDomainAxis());
                    xYPlot.setRangeAxisLocation(n2, MultiAxisChartRenderer.getAxisLocation(subPlot.getAxisLocation()));
                    xYPlot.mapDatasetToRangeAxis(n2, n2);
                } else {
                    this.setDomainAxis(xYPlot2, axis);
                    xYPlot.setDomainAxis(n2, xYPlot2.getDomainAxis());
                    xYPlot.setDomainAxisLocation(n2, MultiAxisChartRenderer.getAxisLocation(subPlot.getAxisLocation()));
                    xYPlot.mapDatasetToDomainAxis(n2, n2);
                }
                axis.getLabel().setText(string3);
                XYRenderer.setValue(xYRenderer, this.m_CompositeChart, xYPlot2, compositeChartUi.getValue(), compositeChartUi.getPositivePosition(), compositeChartUi.getNegativePosition());
                xYPlot.setBackgroundPaint((Paint)StandardColor.lookup(compositeChartUi.getPlotBackground(), (Color)null));
                xYPlot.setRenderer(n2, xYPlot2.getRenderer());
            }
            ++n2;
        }
    }
}

