/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.custom.XYBubbleRenderer;
import com.elixirtech.chart2.model.BubbleType;
import com.elixirtech.chart2.model.BubbleUi;
import com.elixirtech.chart2.model.Chart;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.HeatMapLookupItem;
import com.elixirtech.chart2.model.HeatMapXYType;
import com.elixirtech.chart2.model.HeatMapXYUi;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Position;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.renderer.XYRenderer;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.text.NumberFormat;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.AbstractXYItemLabelGenerator;
import org.jfree.chart.labels.BubbleXYItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.GrayPaintScale;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class XYZRenderer
extends XYRenderer {
    public static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(XYZRenderer.class);

    public XYZRenderer(IChart iChart) {
        super(iChart);
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        String string = this.m_Chart.getType();
        if (string.startsWith("Bubble")) {
            return this.getBubbleChart(object, datasetHolder);
        }
        if (string.startsWith("HeatMapXY")) {
            return this.getHeatMapXYChart(object, datasetHolder);
        }
        return null;
    }

    protected JFreeChart getHeatMapXYChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        RectangleEdge rectangleEdge;
        JFreeChart jFreeChart;
        LookupPaintScale lookupPaintScale;
        XYZDataset xYZDataset = (XYZDataset)datasetHolder.getDataset();
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis();
        numberAxis2.setAutoRangeIncludesZero(false);
        Chart chart = (Chart)this.m_Chart;
        Color color = this.m_Chart.getBackgroundColor();
        HeatMapXYType heatMapXYType = (HeatMapXYType)chart.getChartType();
        HeatMapXYUi heatMapXYUi = ((HeatMapXYType)chart.getChartType()).getHeatMapXYUi();
        XYBlockRenderer xYBlockRenderer = new XYBlockRenderer();
        String string = heatMapXYType.getPaintScale();
        double d = heatMapXYType.getLowerBound();
        double d2 = heatMapXYType.getUpperBound();
        if (d > d2) {
            m_Log.error((Object)("lower bound value, " + d + ", is higher than upper bound, " + d2));
            return null;
        }
        Color color2 = StandardColor.lookup(heatMapXYType.getDefaultPaint(), Color.WHITE);
        String string2 = heatMapXYUi.getScaleLegendLabel();
        GrayPaintScale grayPaintScale = null;
        PaintScaleLegend paintScaleLegend = null;
        boolean bl = "lookup-paintscale".equals(string);
        if (bl) {
            lookupPaintScale = null;
            lookupPaintScale = d >= d2 ? new LookupPaintScale() : new LookupPaintScale(d, d2, (Paint)color2);
            grayPaintScale = lookupPaintScale;
            jFreeChart = heatMapXYType.getHeatMapLookupItemList();
            rectangleEdge = new String[jFreeChart.size() + 1];
            rectangleEdge[0] = "-";
            int n = 1;
            for (HeatMapLookupItem heatMapLookupItem : jFreeChart) {
                double d3 = heatMapLookupItem.getValue();
                Color color3 = StandardColor.lookup(heatMapLookupItem.getPaint(), color2);
                rectangleEdge[n] = heatMapLookupItem.getName();
                lookupPaintScale.add(d3, (Paint)color3);
                ++n;
            }
            SymbolAxis symbolAxis = new SymbolAxis(null, (String[])rectangleEdge);
            symbolAxis.setGridBandsVisible(false);
            try {
                symbolAxis.setRange(d, d2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ChartException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
            symbolAxis.setPlot((Plot)new PiePlot());
            paintScaleLegend = new PaintScaleLegend((PaintScale)lookupPaintScale, (ValueAxis)symbolAxis);
        } else {
            grayPaintScale = d >= d2 ? new GrayPaintScale() : new GrayPaintScale(d, d2);
            lookupPaintScale = new NumberAxis();
            lookupPaintScale.setAxisLinePaint((Paint)Color.BLACK);
            lookupPaintScale.setTickMarkPaint((Paint)Color.BLACK);
            paintScaleLegend = new PaintScaleLegend((PaintScale)grayPaintScale, (ValueAxis)lookupPaintScale);
        }
        xYBlockRenderer.setPaintScale((PaintScale)grayPaintScale);
        xYBlockRenderer.setBlockAnchor(RectangleAnchor.BOTTOM_LEFT);
        lookupPaintScale = new XYPlot((XYDataset)xYZDataset, (ValueAxis)numberAxis, (ValueAxis)numberAxis2, (XYItemRenderer)xYBlockRenderer);
        lookupPaintScale.setRangeGridlinesVisible(true);
        lookupPaintScale.setOrientation(PlotOrientation.VERTICAL);
        lookupPaintScale.setBackgroundPaint((Paint)StandardColor.lookup(heatMapXYUi.getPlotBackground(), (Color)null));
        jFreeChart = new JFreeChart((Plot)lookupPaintScale);
        if (heatMapXYUi.isScaleLegendVisible()) {
            rectangleEdge = this.getPosition(heatMapXYUi.getScaleLegendPosition());
            paintScaleLegend.setMargin(new RectangleInsets(5.0, 10.0, 5.0, 10.0));
            paintScaleLegend.setPosition(this.getPosition(heatMapXYUi.getScaleLegendPosition()));
            paintScaleLegend.setBackgroundPaint((Paint)color);
            jFreeChart.addSubtitle((Title)paintScaleLegend);
            if (StringUtil.notEmpty(string2)) {
                TextTitle textTitle = new TextTitle(string2);
                textTitle.setPosition(rectangleEdge);
                textTitle.setFont(new Font("Sanserif", 0, 11));
                jFreeChart.addSubtitle((Title)textTitle);
                textTitle.setBackgroundPaint((Paint)color);
            }
        }
        XYZRenderer.setTitle(jFreeChart, heatMapXYType.getTitle(), datasetHolder.getTitle());
        jFreeChart.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        this.setRangeAxis((XYPlot)lookupPaintScale, heatMapXYUi.getYAxis());
        this.setDomainAxis((XYPlot)lookupPaintScale, heatMapXYUi.getXAxis());
        XYZRenderer.processScript(object, jFreeChart, this.m_Chart.getOnConfigure());
        jFreeChart.removeLegend();
        lookupPaintScale.setDomainGridlinesVisible(heatMapXYUi.isDomainGridlinesVisible());
        lookupPaintScale.setRangeGridlinesVisible(heatMapXYUi.isRangeGridlinesVisible());
        return jFreeChart;
    }

    private RectangleEdge getPosition(String string) {
        if (string.equals("top")) {
            return RectangleEdge.TOP;
        }
        if (string.equals("right")) {
            return RectangleEdge.RIGHT;
        }
        if (string.equals("left")) {
            return RectangleEdge.LEFT;
        }
        return RectangleEdge.BOTTOM;
    }

    protected JFreeChart getBubbleChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        XYZDataset xYZDataset = (XYZDataset)datasetHolder.getDataset();
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis();
        numberAxis2.setAutoRangeIncludesZero(false);
        BubbleUi bubbleUi = ((BubbleType)((Chart)this.m_Chart).getChartType()).getBubbleUi();
        int n = 0;
        String string = bubbleUi.getAxisScale();
        if (string.equals(BubbleType.SCALES[1])) {
            n = 1;
        } else if (string.equals(BubbleType.SCALES[2])) {
            n = 2;
        }
        XYBubbleRenderer xYBubbleRenderer = new XYBubbleRenderer(n);
        xYBubbleRenderer.setDiameterRatio(bubbleUi.getDiameterRatio());
        XYPlot xYPlot = new XYPlot((XYDataset)xYZDataset, (ValueAxis)numberAxis, (ValueAxis)numberAxis2, (XYItemRenderer)xYBubbleRenderer);
        xYPlot.setOrientation(PlotOrientation.VERTICAL);
        xYPlot.setBackgroundPaint((Paint)StandardColor.lookup(bubbleUi.getPlotBackground(), (Color)null));
        JFreeChart jFreeChart = new JFreeChart((Plot)xYPlot);
        ChartType chartType = ((Chart)this.m_Chart).getChartType();
        XYZRenderer.setLegend(jFreeChart, chartType.getLegend(), datasetHolder.getLegend());
        XYZRenderer.setTitle(jFreeChart, chartType.getTitle(), datasetHolder.getTitle());
        jFreeChart.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        this.setRangeAxis(xYPlot, bubbleUi.getYAxis());
        this.setDomainAxis(xYPlot, bubbleUi.getXAxis());
        xYPlot.setDomainGridlinesVisible(bubbleUi.isDomainGridlinesVisible());
        xYPlot.setRangeGridlinesVisible(bubbleUi.isRangeGridlinesVisible());
        Position position = new Position();
        position.setPosition("Center");
        position.setAnchor("Baseline");
        position.setPivot("Baseline");
        XYZRenderer.setValue(this, this.m_Chart, xYPlot, bubbleUi.getValue(), position, position);
        XYZRenderer.processScript(object, jFreeChart, this.m_Chart.getOnConfigure());
        return jFreeChart;
    }

    protected ValueAxis[] getXYZAxis(XYDataset xYDataset) {
        DateAxis dateAxis = null;
        NumberAxis numberAxis = null;
        NumberAxis numberAxis2 = null;
        if (xYDataset instanceof TimeSeriesCollection) {
            dateAxis = new DateAxis();
            numberAxis = new NumberAxis();
            numberAxis.setAutoRangeIncludesZero(false);
            numberAxis2 = new NumberAxis();
            numberAxis2.setAutoRangeIncludesZero(false);
        } else {
            dateAxis = new NumberAxis();
            ((NumberAxis)dateAxis).setAutoRangeIncludesZero(false);
            numberAxis = new NumberAxis();
            numberAxis.setAutoRangeIncludesZero(false);
            numberAxis2 = new NumberAxis();
            numberAxis2.setAutoRangeIncludesZero(false);
        }
        ValueAxis[] valueAxisArray = new ValueAxis[]{dateAxis, numberAxis, numberAxis};
        return valueAxisArray;
    }

    @Override
    protected AbstractXYItemLabelGenerator getLabelGenerator(String string, NumberFormat numberFormat) {
        if (string.equals("bubble")) {
            if (numberFormat != null) {
                return new BubbleXYItemLabelGenerator("{3}", numberFormat, numberFormat, numberFormat);
            }
            return new BubbleXYItemLabelGenerator();
        }
        return super.getLabelGenerator(string, numberFormat);
    }
}

