/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.SchemaItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class DataRecord {
    protected DataSchema m_Schema;
    protected Object[] m_Data;

    public DataRecord(DataSchema dataSchema) {
        assert (dataSchema != null) : "schema is null";
        this.m_Schema = dataSchema;
    }

    public DataRecord(DataSchema dataSchema, Object[] objectArray) {
        assert (dataSchema != null) : "schema is null";
        this.m_Schema = dataSchema;
        this.setData(objectArray);
    }

    public Object clone() {
        DataRecord dataRecord = new DataRecord(this.m_Schema);
        dataRecord.m_Data = new Object[this.m_Data.length];
        System.arraycopy(this.m_Data, 0, dataRecord.m_Data, 0, this.m_Data.length);
        return dataRecord;
    }

    public DataSchema getSchema() {
        return this.m_Schema;
    }

    public void setData(Object[] objectArray) {
        assert (objectArray.length == this.m_Schema.getColumnCount());
        this.m_Data = objectArray;
    }

    public void setData(DataSchema dataSchema, Object[] objectArray) {
        this.m_Schema = dataSchema;
        this.m_Data = objectArray;
    }

    public void setData(DataRecord dataRecord) {
        this.m_Schema = dataRecord.m_Schema;
        this.m_Data = dataRecord.m_Data;
    }

    public Object[] getData() {
        return this.m_Data;
    }

    public Object getData(int n) {
        return this.m_Data[n];
    }

    public void setData(int n, Object object) {
        this.m_Data[n] = object;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataRecord)) {
            return false;
        }
        DataRecord dataRecord = (DataRecord)object;
        if (this.m_Data.length != dataRecord.m_Data.length) {
            return false;
        }
        for (int i = 0; i < this.m_Data.length; ++i) {
            if (DataRecord.equal(this.m_Data[i], dataRecord.m_Data[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.m_Data.length;
        for (int i = 0; i < this.m_Data.length; ++i) {
            if (this.m_Data[i] == null) continue;
            n ^= this.m_Data[i].hashCode();
        }
        return n;
    }

    public int writeLength() {
        int n = 0;
        SchemaItem[] schemaItemArray = this.m_Schema.m_Items;
        for (int i = 0; i < schemaItemArray.length; ++i) {
            n += schemaItemArray[i].type.writeLength(this.m_Data[i]);
        }
        return n;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        SchemaItem[] schemaItemArray = this.m_Schema.m_Items;
        for (int i = 0; i < schemaItemArray.length; ++i) {
            schemaItemArray[i].type.write(dataOutputStream, this.m_Data[i]);
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        SchemaItem[] schemaItemArray = this.m_Schema.m_Items;
        for (int i = 0; i < schemaItemArray.length; ++i) {
            this.m_Data[i] = schemaItemArray[i].type.read(dataInputStream);
        }
    }

    private static boolean equal(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i < this.m_Data.length; ++i) {
            stringBuilder.append(this.m_Schema.format(this.m_Schema.getColumnType(i), this.m_Data[i]));
            if (i >= this.m_Data.length - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

