/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Encoding {
    private final Charset m_Charset;
    private static final Map<String, Encoding> ENCODING_MAP = new HashMap<String, Encoding>();
    private static final Map<String, Encoding> ALIASES = new HashMap<String, Encoding>();
    private static final List<Encoding> ALL = new ArrayList<Encoding>();
    private static final List<String> ALL_NAMES = new ArrayList<String>();

    public static Encoding get(String string) {
        Encoding encoding = ENCODING_MAP.get(string);
        if (encoding == null) {
            encoding = ALIASES.get(string);
        }
        return encoding;
    }

    public static Vector<String> getAllNames() {
        return new Vector<String>(ALL_NAMES);
    }

    public static Vector<Encoding> getAll() {
        return new Vector<Encoding>(ALL);
    }

    public Encoding(Charset charset) {
        this.m_Charset = charset;
    }

    public String getKey() {
        return this.m_Charset.name();
    }

    public String getRenderableName() {
        return this.m_Charset.displayName();
    }

    public String toString() {
        return this.m_Charset.displayName();
    }

    static {
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        for (Map.Entry entry : sortedMap.entrySet()) {
            Charset charset = (Charset)entry.getValue();
            Encoding encoding = new Encoding(charset);
            ALL.add(encoding);
            ALL_NAMES.add(charset.name());
            ENCODING_MAP.put((String)entry.getKey(), encoding);
            Set<String> set = charset.aliases();
            for (String string : set) {
                ALIASES.put(string, encoding);
            }
        }
        Encoding encoding = ENCODING_MAP.get("Shift_JIS");
        if (encoding != null) {
            ALL_NAMES.add("SJIS");
            ENCODING_MAP.put("SJIS", encoding);
        }
    }

    public static class ComboBoxListener
    implements ItemListener,
    DocumentListener {
        private JComboBox m_CB;
        private JTextField m_Text;

        public ComboBoxListener(JComboBox jComboBox) {
            this.m_CB = jComboBox;
            this.m_CB.addItemListener(this);
            this.m_Text = (JTextField)this.m_CB.getEditor().getEditorComponent();
            this.m_Text.getDocument().addDocumentListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.update((String)itemEvent.getItem());
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(this.m_Text.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(this.m_Text.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.update(this.m_Text.getText());
        }

        private void update(String string) {
            boolean bl = false;
            if (string != null) {
                if (ALL_NAMES.contains(string)) {
                    bl = true;
                } else if (ALIASES.keySet().contains(string)) {
                    bl = true;
                }
            }
            this.m_CB.getEditor().getEditorComponent().setForeground(bl ? Color.BLACK : Color.RED);
        }
    }
}

