/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.arch.package$;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.ExternalSortWriter;
import com.elixirtech.data2.SortReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.function.JProcedure1;

public class ExternalSortReader
implements IterableOnce,
IterableOnceOps,
Iterator,
SortReader {
    private final ExternalSortWriter writer;
    private final List files;
    private final DataSchema schema;
    private ListBuffer readers;

    public ExternalSortReader(ExternalSortWriter writer, List<File> files) {
        this.writer = writer;
        this.files = files;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        Iterator.$init$((Iterator)this);
        this.schema = writer.schema();
        this.readers = (ListBuffer)new ListBuffer().$plus$plus((IterableOnce)files.map((Function1 & Serializable)f -> new ReadStream(this, (File)f)));
        this.readers().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.advance());
    }

    public ExternalSortWriter writer() {
        return this.writer;
    }

    public List<File> files() {
        return this.files;
    }

    public DataSchema schema() {
        return this.schema;
    }

    public ListBuffer<ReadStream> readers() {
        return this.readers;
    }

    public void readers_$eq(ListBuffer<ReadStream> x$1) {
        this.readers = x$1;
    }

    @Override
    public boolean hasNext() {
        return this.readers().nonEmpty();
    }

    @Override
    public DataRecord next() {
        this.readers_$eq((ListBuffer<ReadStream>)((ListBuffer)this.readers().sortWith((Function2 & Serializable)(o1, o2) -> this.comparator((ReadStream)o1, (ReadStream)o2))));
        DataRecord ret = ((ReadStream)this.readers().head()).record();
        ((ReadStream)this.readers().head()).advance();
        return ret;
    }

    public boolean comparator(ReadStream o1, ReadStream o2) {
        Object[] d1 = this.writer().getSortItems(o1.record());
        Object[] d2 = this.writer().getSortItems(o2.record());
        return this.writer().compare(0, this.writer().comparators(), d1, d2) < 0;
    }

    @Override
    public void close() {
        this.readers().toList().foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.close());
    }

    public class ReadStream {
        private final File file;
        private DataRecord _record;
        private boolean end;
        private final DataInputStream dis;
        private final /* synthetic */ ExternalSortReader $outer;

        public ReadStream(ExternalSortReader $outer, File file) {
            this.file = file;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.end = false;
            this.dis = package$.MODULE$.enrichInputStream((InputStream)package$.MODULE$.enrichInputStream((InputStream)package$.MODULE$.enrichFile(file).input()).buffered()).data();
        }

        public File file() {
            return this.file;
        }

        public DataInputStream dis() {
            return this.dis;
        }

        public void advance() {
            if (this.end) {
                return;
            }
            byte marker = this.dis().readByte();
            if (marker == 82) {
                Object[] data = new Object[this.$outer.schema().getColumnCount()];
                DataRecord rec = new DataRecord(this.$outer.schema(), data);
                rec.read(this.dis());
                this._record = rec;
                return;
            }
            if (marker == 88) {
                this.close();
                return;
            }
        }

        public void close() {
            if (!this.end) {
                this.end = true;
                this._record = null;
                this.dis().close();
                this.file().delete();
                this.$outer.readers().$minus$eq((Object)this);
                return;
            }
        }

        public DataRecord record() {
            return this._record;
        }

        public final /* synthetic */ ExternalSortReader com$elixirtech$data2$ExternalSortReader$ReadStream$$$outer() {
            return this.$outer;
        }
    }
}

