/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.arch.util.StringStepper;

public class ParamMatcher {
    private final String m_String;
    private final int m_Length;
    private int m_Start;
    private int m_End;
    private String m_Name;
    private String m_Type;
    private String m_Default;

    public ParamMatcher(String string) {
        this.m_String = string;
        this.m_Length = this.m_String.length();
    }

    public boolean find() {
        for (int i = this.m_End; i < this.m_Length; ++i) {
            char c;
            char c2 = this.charAt(i);
            if (c2 != '$' || (c = this.charAt(i + 1)) != '{') continue;
            int n = i + 2;
            char c3 = this.charAt(n);
            while (c3 != '}') {
                if (c3 == '\u0000') {
                    return false;
                }
                if (c3 == '\\') {
                    ++n;
                }
                c3 = this.charAt(++n);
            }
            this.m_Start = i;
            this.m_End = n + 1;
            return this.buildMatch();
        }
        return false;
    }

    public String getName() {
        return this.m_Name;
    }

    public String getType() {
        return this.m_Type;
    }

    public String getDefault() {
        return this.m_Default;
    }

    public int getStart() {
        return this.m_Start;
    }

    public int getEnd() {
        return this.m_End;
    }

    private boolean buildMatch() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        String string = this.m_String.substring(this.m_Start + 2, this.m_End - 1);
        StringStepper stringStepper = new StringStepper(string);
        StringBuilder[] stringBuilderArray = new StringBuilder[]{stringBuilder, stringBuilder2, stringBuilder3};
        int n = 0;
        while (!stringStepper.atEnd()) {
            char c = stringStepper.getChar().charValue();
            if (c == '\\') {
                stringStepper.advance();
                if (!stringStepper.atEnd()) {
                    stringBuilderArray[n].append(stringStepper.getChar());
                }
            } else if (c == '#') {
                if (++n == stringBuilderArray.length) {
                    break;
                }
            } else {
                stringBuilderArray[n].append(c);
            }
            stringStepper.advance();
        }
        this.m_Name = stringBuilder.toString().trim();
        this.m_Type = stringBuilder2.toString().trim();
        this.m_Default = n > 1 ? stringBuilder3.toString() : null;
        return true;
    }

    private char charAt(int n) {
        if (n >= this.m_Length) {
            return '\u0000';
        }
        return this.m_String.charAt(n);
    }
}

