/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DSLookup;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class ParameterUtil {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ParameterUtil.class);

    public static int getParamCount(List<Parameter> list) {
        int n = 0;
        for (Parameter parameter : list) {
            if (ParameterUtil.ignoreParam(parameter)) continue;
            ++n;
        }
        return n;
    }

    public static List<Parameter> getParams(List<Parameter> list) {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        for (Parameter parameter : list) {
            if (ParameterUtil.ignoreParam(parameter)) continue;
            arrayList.add(parameter);
        }
        return arrayList;
    }

    public static boolean ignoreParam(Parameter parameter) {
        boolean bl = false;
        String string = parameter.getName();
        if (!(bl |= string.startsWith("elixir.report.ds."))) {
            bl |= "data".equalsIgnoreCase(parameter.getType());
        }
        if (!bl) {
            bl = System.getProperty(string) != null;
        }
        return bl;
    }

    public static String getFormat(String string) {
        String string2 = string.trim();
        if (string2.startsWith("date(")) {
            string2 = string2.substring(5);
        }
        if (string2.endsWith(")")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static String[] getChoices(String string) {
        String string2 = string.trim();
        if (string2.startsWith("choice(")) {
            string2 = string2.substring(7);
        }
        if (string2.endsWith(")")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String[] stringArray = string2.split("(?<=[^\\\\])[\\,]");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replaceAll("[\\\\](.)", "$1");
        }
        return stringArray;
    }

    public static String[] getLookup(String string) {
        String string2 = string.trim();
        if (string2.startsWith("lookup(")) {
            string2 = string2.substring(7);
        }
        if (string2.endsWith(")")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String[] stringArray = string2.split("(?<=[^\\\\])[\\,]");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replaceAll("[\\\\](.)", "$1");
        }
        return stringArray;
    }

    public static Object[] lookupChoices(DSLookup dSLookup, String[] stringArray) {
        Object object;
        if (stringArray == null || stringArray.length < 2) {
            return new Object[0];
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 2; i < stringArray.length; ++i) {
            object = StringUtil.keyAndValue(stringArray[i]);
            hashMap.put(object[0], object[1]);
        }
        try {
            IDataSource iDataSource = ParameterUtil.getDataSource(dSLookup, string);
            if (iDataSource == null) {
                m_Log.warn((Object)("Can't access datasource " + string));
                return new Object[0];
            }
            object = new DefaultPushContext();
            ((DefaultPushContext)object).setParameters(hashMap);
            DataTable dataTable = DataTable.build((PushContext)object, iDataSource);
            DataSchema dataSchema = dataTable.getSchema();
            int n = dataSchema.getColumnIndex(string2);
            if (n < 0) {
                m_Log.warn((Object)("Can't access datasource " + string + " field " + string2));
                return new Object[0];
            }
            DataType dataType = dataSchema.getColumnType(n);
            TreeSet<String> treeSet = new TreeSet<String>();
            DataRecord[] dataRecordArray = dataTable.getRecords();
            for (int i = 0; i < dataRecordArray.length; ++i) {
                Object object2 = dataRecordArray[i].getData(n);
                treeSet.add(dataSchema.format(dataType, object2));
            }
            Object[] objectArray = new String[treeSet.size()];
            treeSet.toArray(objectArray);
            return objectArray;
        }
        catch (DataException dataException) {
            m_Log.error((Object)("Can't lookup values: " + String.valueOf(dataException)), (Throwable)dataException);
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("Unexpected error: " + String.valueOf(throwable)), throwable);
        }
        return new Object[0];
    }

    public static Object getValue(String string, Object[] objectArray) {
        if (StringUtil.notEmpty(string)) {
            String string2 = string.trim();
            if ("[first]".equals(string2) && objectArray.length > 0) {
                return objectArray[0];
            }
            if ("[last]".equals(string2) && objectArray.length > 0) {
                return objectArray[objectArray.length - 1];
            }
            if (string2.startsWith("[") && string2.endsWith("]")) {
                try {
                    int n = Integer.parseInt(string2.substring(1, string2.length() - 1));
                    if (n > 0 && n <= objectArray.length) {
                        return objectArray[n - 1];
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    protected static IDataSource getDataSource(DSLookup dSLookup, String string) throws DataException {
        IDataSource iDataSource = null;
        if (dSLookup != null) {
            iDataSource = dSLookup.getDataSource(string);
        }
        if (iDataSource == null) {
            DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
            iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
        }
        return iDataSource;
    }
}

