/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import java.util.ArrayList;
import java.util.List;

public class TableBuilder {
    private final String m_Name;
    private final DataSchema m_Schema;
    private final List<DataRecord> m_Records = new ArrayList<DataRecord>();
    private DataRecord m_Record;
    private int m_CurrentIndex;

    public TableBuilder(String string, DataSchema dataSchema) {
        this.m_Name = string;
        this.m_Schema = dataSchema;
    }

    public int getRecordCount() {
        return this.m_Records.size();
    }

    public void setCurrentIndex(int n) {
        if (n < 0 || n >= this.m_Records.size()) {
            throw new IndexOutOfBoundsException("index " + n + " not in range 0-" + (this.m_Records.size() - 1));
        }
        this.m_CurrentIndex = n;
        this.m_Record = this.m_Records.get(this.m_CurrentIndex);
    }

    public int getCurrentIndex() {
        return this.m_CurrentIndex;
    }

    public boolean hasNext() {
        return this.m_CurrentIndex < this.m_Records.size() - 1;
    }

    public void next() {
        if (this.hasNext()) {
            ++this.m_CurrentIndex;
        } else {
            throw new IndexOutOfBoundsException("No more records available");
        }
        this.m_Record = this.m_Records.get(this.m_CurrentIndex);
    }

    public void appendRecord() {
        this.m_Record = new DataRecord(this.m_Schema);
        this.m_CurrentIndex = this.m_Records.size();
        this.m_Records.add(this.m_Record);
    }

    public void put(String string, Object object) {
        this.put(this.m_Schema.getColumnIndex(string), object);
    }

    public void put(int n, Object object) {
        this.m_Record.setData(n, object);
    }

    public Object get(String string) {
        return this.get(this.m_Schema.getColumnIndex(string));
    }

    public Object get(int n) {
        return this.m_Record.getData(n);
    }

    public DataTable getTable() {
        DataRecord[] dataRecordArray = new DataRecord[this.m_Records.size()];
        this.m_Records.toArray(dataRecordArray);
        return new DataTable(this.m_Name, this.m_Schema, dataRecordArray);
    }
}

