/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource;

import com.elixirtech.arch.BasicSecurity;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ICachedFile;
import com.elixirtech.arch.ISecurity;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.SchemaHelper;
import com.elixirtech.data2.datasource.DataSourceRegistry;
import com.elixirtech.jdom.Element;
import com.elixirtech.repository.RMLFileObject;
import java.util.List;

public abstract class DataSourceDefinition
implements Data2Constants {
    public static final String NAME = "name";
    public static final String PATH = "path";
    public static final String PARENT = "parent";
    public static final String DESCRIPTION = "description";
    public static final String TYPE = "type";
    public static final String SCHEMA = "schema";
    public static final String SECURITY = "security";
    public static final String VERSION = "version";
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DataSourceDefinition.class);

    public static IDataSource load(DataSourceManager dataSourceManager, Element element) {
        try {
            Class<? extends DataSourceDefinition> clazz = DataSourceDefinition.getDefinition(element);
            if (clazz != null) {
                DataSourceDefinition dataSourceDefinition = clazz.newInstance();
                IDataSource iDataSource = dataSourceDefinition.getDataSource(dataSourceManager, element);
                return iDataSource;
            }
            m_Log.error((Object)("Can't load definition for " + element.getAttributeValue(TYPE)));
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't load DataSource: " + String.valueOf(exception)), (Throwable)exception);
        }
        return null;
    }

    public static Element save(IDataSource iDataSource) {
        try {
            DataSourceDefinition dataSourceDefinition;
            Class<? extends DataSourceDefinition> clazz = DataSourceDefinition.getDefinition(iDataSource);
            if (clazz != null && (dataSourceDefinition = clazz.newInstance()) != null) {
                Element element = dataSourceDefinition.setDataSource(iDataSource);
                return element;
            }
            return null;
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't save DataSource: " + String.valueOf(exception)), (Throwable)exception);
            return null;
        }
    }

    public static IDataSource clone(DataSourceManager dataSourceManager, IDataSource iDataSource) {
        try {
            Class<? extends DataSourceDefinition> clazz = DataSourceDefinition.getDefinition(iDataSource);
            if (clazz != null) {
                Element element;
                DataSourceDefinition dataSourceDefinition = clazz.newInstance();
                IDataSource iDataSource2 = dataSourceDefinition.getDataSource(dataSourceManager, element = dataSourceDefinition.setDataSource(iDataSource));
                ICachedFile iCachedFile = iDataSource2.getAdapter(ICachedFile.class);
                if (iCachedFile != null) {
                    iCachedFile.setFileObject(iDataSource.getAdapter(ICachedFile.class).getFileObject());
                }
                m_Log.info((Object)("Clone " + iDataSource.getName() + " complete"));
                return iDataSource2;
            }
            m_Log.error((Object)("Can't load definition for " + iDataSource.getType()));
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't clone DataSource: " + String.valueOf(exception)), (Throwable)exception);
        }
        return null;
    }

    public abstract IDataSource getDataSource(DataSourceManager var1, Element var2) throws DataException;

    public abstract Element setDataSource(IDataSource var1) throws DataException;

    public static boolean isDefined(String string) {
        return DataSourceRegistry.isDefined(string);
    }

    protected static Class<? extends DataSourceDefinition> getDefinition(Element element) {
        return DataSourceRegistry.getDefinitionJ(element.getAttributeValue(TYPE));
    }

    protected static Class<? extends DataSourceDefinition> getDefinition(IDataSource iDataSource) {
        Class<? extends DataSourceDefinition> clazz = DataSourceRegistry.getDefinitionJ(iDataSource.getType());
        if (clazz == null) {
            m_Log.error((Object)("Can't load definition for " + iDataSource.getType()));
        }
        return clazz;
    }

    protected Element defineDataSource(IDataSource iDataSource) {
        String string;
        RMLFileObject rMLFileObject;
        Element element = new Element("datasource", NS_DATASOURCE);
        element.setAttribute(NAME, iDataSource.getName());
        element.setAttribute(TYPE, iDataSource.getType());
        ICachedFile iCachedFile = iDataSource.getAdapter(ICachedFile.class);
        RMLFileObject rMLFileObject2 = rMLFileObject = iCachedFile != null ? iCachedFile.getFileObject() : null;
        if (rMLFileObject != null) {
            element.setAttribute(PATH, rMLFileObject.getPathString());
        }
        if ((string = iDataSource.getDescription()) == null) {
            string = "";
        }
        element.setAttribute(DESCRIPTION, string);
        List<Parameter> list = iDataSource.getParameters();
        Element element2 = new Element("parameter-cache", NS_DATASOURCE);
        for (Parameter parameter : list) {
            Element element3 = new Element("parameter", NS_DATASOURCE);
            element3.setAttribute(NAME, DataSourceDefinition.safe(parameter.getName()));
            element3.setAttribute(TYPE, DataSourceDefinition.safe(parameter.getType()));
            element3.setAttribute("default-value", DataSourceDefinition.safe(parameter.getDefaultValue()));
            for (String string2 : parameter.getDependencies()) {
                Element element4 = new Element("dependency", NS_DATASOURCE);
                element4.setAttribute("on", string2);
                element3.addContent(element4);
            }
            element2.addContent(element3);
        }
        element.addContent(element2);
        return element;
    }

    public static DataSchema loadSchema(Element element) {
        return SchemaHelper.fromJDOM(element);
    }

    public static void saveSchema(DataSchema dataSchema, Element element) {
        element.addContent(SchemaHelper.toJDOM(dataSchema));
    }

    protected ISecurity loadSecurity(Element element) {
        BasicSecurity basicSecurity = new BasicSecurity();
        Element element2 = element.getChild(SECURITY, NS_DATASOURCE);
        if (element2 != null) {
            String string = element2.getAttributeValue("encrypted");
            String string2 = element2.getAttributeValue("password");
            String string3 = element2.getAttributeValue("read-only");
            String string4 = element2.getAttributeValue("hide-internals");
            String string5 = element2.getAttributeValue(NAME);
            basicSecurity.setEncrypted("Yes".equals(string));
            basicSecurity.setPassword(string2);
            basicSecurity.setReadOnly("Yes".equals(string3));
            basicSecurity.setHideInternals("Yes".equals(string4));
            basicSecurity.setName(string5);
        }
        return basicSecurity;
    }

    protected void saveSecurity(ISecurity iSecurity, Element element) {
        if (iSecurity != null) {
            String string;
            Element element2 = new Element(SECURITY, NS_DATASOURCE);
            if (iSecurity.isEncrypted()) {
                element2.setAttribute("encrypted", "Yes");
                if (iSecurity.getPassword() != null) {
                    element2.setAttribute("password", iSecurity.getPassword());
                }
            }
            if (iSecurity.isReadOnly()) {
                element2.setAttribute("read-only", "Yes");
            }
            if (iSecurity.isHideInternals()) {
                element2.setAttribute("hide-internals", "Yes");
            }
            if ((string = iSecurity.getName()) != null) {
                element2.setAttribute(NAME, string);
            }
            element.addContent(element2);
        }
    }

    protected IDataSource getParent(DataSourceManager dataSourceManager, Element element) throws DataException {
        IDataSource iDataSource = null;
        String string = element.getAttributeValue(PARENT);
        if (string != null) {
            iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
        } else {
            Element element2 = element.getChild("datasource", NS_DATASOURCE);
            if (element2 == null) {
                throw new DataException("Can't load derivative/base element");
            }
            iDataSource = DataSourceDefinition.load(dataSourceManager, element2);
        }
        return iDataSource;
    }

    protected static String safe(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    protected static int getInt(String string) {
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                m_Log.warn((Object)("Bad int value: " + string));
            }
        }
        return 0;
    }

    protected static void setAttribute(Element element, String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            element.setAttribute(string, string2);
        }
    }

    protected static void setAttribute(Element element, String string, int n) {
        element.setAttribute(string, Integer.toString(n));
    }

    protected static void setAttribute(Element element, String string, boolean bl) {
        element.setAttribute(string, bl ? "Yes" : "No");
    }
}

