/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource;

import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.RawDataDefinition$;
import com.elixirtech.data2.datasource.RawDataSource;
import com.elixirtech.data2.datasource.RawDataSource$;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Namespace;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.runtime.BoxesRunTime;

public class RawDataDefinition
extends DataSourceDefinition {
    public static DataRecord buildRecord(DataSchema dataSchema, Element element) {
        return RawDataDefinition$.MODULE$.buildRecord(dataSchema, element);
    }

    @Override
    public IDataSource getDataSource(DataSourceManager dsm, Element e) {
        block3: {
            block2: {
                if (!"datasource".equals(e.getName())) break block2;
                Namespace namespace = e.getNamespace();
                Namespace namespace2 = Data2Constants.NS_DATASOURCE;
                if (!(namespace == null ? namespace2 != null : !((Object)namespace).equals(namespace2))) break block3;
            }
            throw new IllegalArgumentException("Element " + e.getName() + " is not a ds:datasource");
        }
        String name = e.getAttributeValue("name");
        Element schemaElement = (Element)Option$.MODULE$.apply((Object)e.getChild("schema", Data2Constants.NS_DATASOURCE)).getOrElse(RawDataDefinition::$anonfun$1);
        DataSchema schema = DataSourceDefinition.loadSchema(schemaElement);
        Element data = (Element)Option$.MODULE$.apply((Object)e.getChild("data", Data2Constants.NS_DATASOURCE)).getOrElse(RawDataDefinition::$anonfun$2);
        RawDataSource src = RawDataSource$.MODULE$.apply(schema, data);
        src.setName(name);
        src.setDescription(e.getAttributeValue("description"));
        src.setSecurity(this.loadSecurity(e));
        return src;
    }

    @Override
    public Element setDataSource(IDataSource ds) {
        IDataSource iDataSource = ds;
        if (iDataSource instanceof RawDataSource) {
            RawDataSource src = (RawDataSource)iDataSource;
            Element datasource = this.defineDataSource(src);
            DataSourceDefinition.saveSchema(src.getSchema(), datasource);
            this.saveSecurity(src.getSecurity(), datasource);
            DataTable table = src.getTable();
            Element data = new Element("data", Data2Constants.NS_DATASOURCE);
            Object object = Predef$.MODULE$.refArrayOps((Object[])table.getRecords());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)rec -> data.addContent(this.generateRecord((DataRecord)rec)));
            datasource.addContent(data);
            return datasource;
        }
        throw new IllegalArgumentException("Not a RawDataSource");
    }

    public Element generateRecord(DataRecord rec) {
        DataSchema schema = rec.getSchema();
        Element record = new Element("record", Data2Constants.NS_DATASOURCE);
        Object object = Predef$.MODULE$.refArrayOps(rec.getData());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object value = tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                DataType dtype = schema.getColumnType(i);
                Element field = new Element("field", Data2Constants.NS_DATASOURCE);
                field.setText(schema.format(dtype, value));
                return record.addContent(field);
            }
            throw new MatchError((Object)tuple2);
        });
        return record;
    }

    private static final Element $anonfun$1() {
        throw new DataException("Can't load schema");
    }

    private static final Element $anonfun$2() {
        throw new DataException("Can't load data element");
    }
}

