/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource;

import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.FileBasedDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.RawDataDefinition$;
import com.elixirtech.data2.datasource.RawDataIterator;
import com.elixirtech.data2.datasource.RawDataSource$;
import com.elixirtech.data2.iterator.IDataRecordIterable;
import com.elixirtech.data2.iterator.IDataRecordIterator;
import com.elixirtech.jdom.Element;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.Map;

public class RawDataSource
extends FileBasedDataSource
implements IDataRecordIterable {
    private final DataTable m_Table;
    private final String TYPE;
    private String name;
    private String description;

    public static RawDataSource apply() {
        return RawDataSource$.MODULE$.apply();
    }

    public static RawDataSource apply(DataSchema dataSchema, Element element) {
        return RawDataSource$.MODULE$.apply(dataSchema, element);
    }

    public RawDataSource(DataTable m_Table) {
        this.m_Table = m_Table;
        this.TYPE = "Data";
        this.name = "";
        this.description = "";
    }

    public String TYPE() {
        return this.TYPE;
    }

    @Override
    public <T> T getAdapter(Class<T> cls) {
        Class<T> clazz = cls;
        Class<IDataRecordIterable> clazz2 = IDataRecordIterable.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return cls.cast(this);
        }
        return super.getAdapter(cls);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getType() {
        return this.TYPE();
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Table.getSchema();
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    @Override
    public void pushTo(PushContext cxt, DataListener dl) {
        this.m_Table.pushTo(cxt, dl);
    }

    public DataTable getTable() {
        return this.m_Table;
    }

    @Override
    public IDataRecordIterator iterator(Map<String, String> parameters) {
        return new RawDataIterator(this.m_Table);
    }

    public static class Builder
    extends AbstractDataSource {
        private final DataSchema schema;
        private final Element data;

        public Builder(DataSchema schema, Element data) {
            this.schema = schema;
            this.data = data;
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public String getDescription() {
            return "";
        }

        @Override
        public String getType() {
            return "";
        }

        @Override
        public DataSchema getSchema() {
            return this.schema;
        }

        @Override
        public void pushTo(PushContext cxt, DataListener dl) {
            dl.startData(this);
            this.processChildren(this.data, dl);
            dl.endData(this);
        }

        public void processChildren(Element parent, DataListener dl) {
            for (Element e : parent.getChildren()) {
                String name = e.getName();
                if ("group".equals(name)) {
                    int level = Integer.parseInt(e.getAttributeValue("level"));
                    String groupName = e.getAttributeValue("name");
                    DataGroup group = new DataGroup(level, groupName);
                    dl.startGroup(group);
                    this.processChildren(e, dl);
                    dl.endGroup(group);
                    continue;
                }
                if (!"record".equals(name)) continue;
                Option option = Option$.MODULE$.apply((Object)RawDataDefinition$.MODULE$.buildRecord(this.schema, e));
                if (option instanceof Some) {
                    DataRecord record = (DataRecord)((Some)option).value();
                    dl.processRecord(record);
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new RuntimeException("Can't read record");
                }
                throw new MatchError((Object)option);
            }
        }
    }
}

