/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.cache;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.datasource.cache.CachedDataSource;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class CacheReader {
    private CachedDataSource m_Source;
    private File m_File;
    private DataSchema m_Schema;
    private boolean m_SkipRecords;
    private int m_SkippedStartGroups;
    private int m_GroupLevel;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CacheReader.class);

    public CacheReader(CachedDataSource cachedDataSource, File file, DataListener dataListener) throws DataException, IOException {
        this.m_File = file;
        m_Log.info((Object)("CacheReader pushing from " + this.m_File.getAbsolutePath()));
        this.m_Source = cachedDataSource;
        this.m_Schema = this.m_Source.getSchema();
        Object[] objectArray = new Object[this.m_Schema.getColumnCount()];
        DataRecord dataRecord = new DataRecord(this.m_Schema, objectArray);
        DataType[] dataTypeArray = new DataType[objectArray.length];
        for (int i = 0; i < dataTypeArray.length; ++i) {
            dataTypeArray[i] = this.m_Schema.getColumnType(i);
        }
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.m_File));
        block8: while (true) {
            char c = dataInputStream.readChar();
            char c2 = dataInputStream.readChar();
            if (c != 'M') {
                throw new IOException("Sync exception got marker: " + c);
            }
            switch (c2) {
                case 'B': {
                    dataListener.startData(this.m_Source);
                    break;
                }
                case 'S': {
                    DataGroup dataGroup;
                    ++this.m_GroupLevel;
                    int n = dataInputStream.readInt();
                    String string = dataInputStream.readUTF();
                    if (!this.m_SkipRecords) {
                        dataGroup = new DataGroup(n, string);
                        dataListener.startGroup(dataGroup);
                        break;
                    }
                    ++this.m_SkippedStartGroups;
                    break;
                }
                case 'R': {
                    int n = dataInputStream.readInt();
                    if (!this.m_SkipRecords) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            char c3 = dataInputStream.readChar();
                            if (c3 == 'N') {
                                objectArray[i] = null;
                                continue;
                            }
                            if (c3 == 'D') {
                                objectArray[i] = this.readData(dataInputStream, dataTypeArray[i]);
                                continue;
                            }
                            throw new IOException("Unknown data identifier: " + c3);
                        }
                        if (dataListener.processRecord(dataRecord)) continue block8;
                        this.m_SkipRecords = true;
                        if (this.m_GroupLevel != 0) continue block8;
                        dataListener.endData(this.m_Source);
                        dataInputStream.close();
                        break block8;
                    }
                    dataInputStream.skipBytes(n);
                    break;
                }
                case 'E': {
                    DataGroup dataGroup;
                    --this.m_GroupLevel;
                    int n = dataInputStream.readInt();
                    String string = dataInputStream.readUTF();
                    if (!this.m_SkipRecords || this.m_SkippedStartGroups == 0) {
                        dataGroup = new DataGroup(n, string);
                        dataListener.endGroup(dataGroup);
                        break;
                    }
                    --this.m_SkippedStartGroups;
                    break;
                }
                case 'X': {
                    dataListener.endData(this.m_Source);
                    dataInputStream.close();
                    break block8;
                }
                default: {
                    throw new IOException("Unknown identifier: " + c2);
                }
            }
        }
    }

    protected Object readData(DataInputStream dataInputStream, DataType dataType) throws DataException, IOException {
        switch (dataType.getTypeId()) {
            case 8: {
                return new Long(dataInputStream.readLong());
            }
            case 6: {
                return new Double(dataInputStream.readDouble());
            }
            case 2: {
                return dataInputStream.readUTF();
            }
            case 3: {
                return dataInputStream.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return this.m_Schema.parse(dataType, dataInputStream.readUTF());
    }
}

