/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.cache;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.datasource.cache.CachedDataSource;
import com.elixirtech.data2.datasource.cache.UTF8;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class CacheReader2 {
    private CachedDataSource m_Source;
    private File m_File;
    private DataSchema m_Schema;
    private boolean m_SkipRecords;
    private int m_SkippedStartGroups;
    private int m_GroupLevel;
    private RandomAccessFile m_RAFile;
    private FileChannel m_FileChannel;
    private MappedByteBuffer m_ByteBuffer;
    private byte m_MajorVersion;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CacheReader2.class);

    public static void clean(final Object object) {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Method method = object.getClass().getMethod("cleaner", new Class[0]);
                        method.setAccessible(true);
                        Object object2 = method.invoke(object, new Object[0]);
                        Method method2 = object2.getClass().getMethod("clean", new Class[0]);
                        method2.invoke(object2, new Object[0]);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public CacheReader2(CachedDataSource cachedDataSource, File file) throws DataException, IOException {
        this.m_File = file;
        m_Log.info((Object)("CacheReader pushing from " + this.m_File.getAbsolutePath()));
        this.m_RAFile = new RandomAccessFile(this.m_File, "r");
        this.m_FileChannel = this.m_RAFile.getChannel();
        this.m_ByteBuffer = this.m_FileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.m_FileChannel.size());
        this.readVersion();
        this.m_Schema = this.readSchema(this.m_ByteBuffer);
        this.m_Source = cachedDataSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pushTo(PushContext pushContext, DataListener dataListener) throws DataException, IOException {
        char c;
        int n = this.m_Schema.getColumnCount();
        DataType[] dataTypeArray = new DataType[n];
        for (c = '\u0000'; c < dataTypeArray.length; ++c) {
            dataTypeArray[c] = this.m_Schema.getColumnType(c);
        }
        while (true) {
            Object[] objectArray;
            block19: {
                try {
                    while (true) {
                        c = this.m_ByteBuffer.getChar();
                        char c2 = this.m_ByteBuffer.getChar();
                        if (c != 'M') {
                            throw new IOException("Sync exception got marker: " + c);
                        }
                        switch (c2) {
                            case 'B': {
                                break;
                            }
                            case 'S': {
                                DataGroup dataGroup;
                                ++this.m_GroupLevel;
                                int n2 = this.m_ByteBuffer.getInt();
                                objectArray = UTF8.read(this.m_ByteBuffer);
                                if (!this.m_SkipRecords) {
                                    dataGroup = new DataGroup(n2, (String)objectArray);
                                    dataListener.startGroup(dataGroup);
                                    break;
                                }
                                ++this.m_SkippedStartGroups;
                                break;
                            }
                            case 'R': {
                                int n2 = this.m_ByteBuffer.getInt();
                                if (!this.m_SkipRecords) {
                                    objectArray = new Object[n];
                                    break block19;
                                } else {
                                    this.m_ByteBuffer.position(this.m_ByteBuffer.position() + n2);
                                    break;
                                }
                            }
                            case 'E': {
                                DataGroup dataGroup;
                                --this.m_GroupLevel;
                                int n2 = this.m_ByteBuffer.getInt();
                                objectArray = UTF8.read(this.m_ByteBuffer);
                                if (!this.m_SkipRecords || this.m_SkippedStartGroups == 0) {
                                    dataGroup = new DataGroup(n2, (String)objectArray);
                                    dataListener.endGroup(dataGroup);
                                    break;
                                }
                                --this.m_SkippedStartGroups;
                                break;
                            }
                            case 'X': {
                                dataListener.endData(this.m_Source);
                                return;
                            }
                            default: {
                                throw new IOException("Unknown identifier: " + c2);
                            }
                        }
                    }
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    throw new DataException("Cache BufferUnderflowException: the cache is corrupt.");
                }
            }
            for (int i = 0; i < n; ++i) {
                char c3 = this.m_ByteBuffer.getChar();
                if (c3 == 'N') {
                    objectArray[i] = null;
                    continue;
                }
                if (c3 != 'D') throw new IOException("Unknown data identifier: " + c3);
                objectArray[i] = this.readData(dataTypeArray[i]);
            }
            pushContext.throb();
            if (dataListener.processRecord(new DataRecord(this.m_Schema, objectArray))) continue;
            this.m_SkipRecords = true;
            if (this.m_GroupLevel == 0) break;
        }
        dataListener.endData(this.m_Source);
    }

    public void close() throws IOException {
        if (this.m_RAFile != null) {
            CacheReader2.clean(this.m_ByteBuffer);
            this.m_FileChannel.close();
            this.m_RAFile.close();
            this.m_ByteBuffer = null;
            this.m_FileChannel = null;
            this.m_RAFile = null;
        }
    }

    public DataSchema getSchema() {
        return this.m_Schema;
    }

    protected Object readData(DataType dataType) throws DataException, IOException {
        switch (dataType.getTypeId()) {
            case 8: {
                return new Long(this.m_ByteBuffer.getLong());
            }
            case 6: {
                return new Double(this.m_ByteBuffer.getDouble());
            }
            case 2: {
                return UTF8.read(this.m_ByteBuffer);
            }
            case 3: {
                return this.m_ByteBuffer.get() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return this.m_Schema.parse(dataType, UTF8.read(this.m_ByteBuffer));
    }

    protected void readVersion() throws IOException {
        this.m_MajorVersion = this.m_ByteBuffer.get();
        byte by = this.m_ByteBuffer.get();
        if (this.m_MajorVersion < 1 || this.m_MajorVersion > 2) {
            throw new IOException("Invalid cache version: " + this.m_MajorVersion + ":" + by);
        }
    }

    protected DataSchema readSchema(MappedByteBuffer mappedByteBuffer) throws IOException {
        char c = mappedByteBuffer.getChar();
        if (c != 'M') {
            throw new IOException("Invalid schema marker: " + c);
        }
        boolean bl = mappedByteBuffer.get() != 0;
        SchemaBuilder schemaBuilder = new SchemaBuilder(bl);
        String string = UTF8.read(mappedByteBuffer);
        String string2 = UTF8.read(mappedByteBuffer);
        String string3 = UTF8.read(mappedByteBuffer);
        int n = mappedByteBuffer.getInt();
        for (int i = 0; i < n; ++i) {
            int n2;
            byte by = mappedByteBuffer.get();
            DataType dataType = DataType.getInstance(by);
            String string4 = UTF8.read(mappedByteBuffer);
            DataAttributes dataAttributes = new DataAttributes();
            if (this.m_MajorVersion > 1 && (n2 = mappedByteBuffer.getInt()) > 0) {
                for (int j = 0; j < n2; ++j) {
                    String string5 = UTF8.read(mappedByteBuffer);
                    DataAttribute dataAttribute = DataAttribute.newDataAttribute(string5);
                    if (dataAttribute == null) continue;
                    dataAttributes.addAttribute(dataAttribute);
                }
            }
            schemaBuilder.add(string4, dataType, dataAttributes);
        }
        DataSchema dataSchema = schemaBuilder.getSchema();
        dataSchema.setDateFormat(string);
        dataSchema.setTimeFormat(string2);
        dataSchema.setTimestampFormat(string3);
        return dataSchema;
    }
}

