/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.cache2;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.datasource.cache2.ICache;
import com.elixirtech.data2.datasource.cache2.ICacheManager;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.repository.RMLRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CacheManager
extends Thread
implements ICacheManager {
    private final Map<String, List<ICache>> m_CacheMap = new HashMap<String, List<ICache>>();
    private long m_ExpiryInterval = 300000L;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CacheManager.class);
    public static final long EXPIRY_INTERVAL = 300000L;

    public CacheManager() {
        super("CacheManager");
        this.setDaemon(true);
        this.start();
    }

    @Override
    public synchronized void resetCache(String string) {
        m_Log.debug((Object)("Reset cachePath: " + string));
        this.m_CacheMap.remove(string);
    }

    @Override
    public void setExpiryInterval(long l) {
        if (l < 1000L) {
            throw new IllegalArgumentException("Interval too small (<1000ms)");
        }
        this.m_ExpiryInterval = l;
    }

    @Override
    public synchronized ICache getCache(String string, DataSchema dataSchema, String string2) {
        List<ICache> list = this.m_CacheMap.get(string);
        if (list == null) {
            return null;
        }
        ArrayList<ICache> arrayList = new ArrayList<ICache>();
        ICache iCache = null;
        for (ICache iCache2 : list) {
            if (iCache2.hasExpired()) {
                m_Log.debug((Object)("Removing expired cache during lookup: " + String.valueOf(iCache2)));
                arrayList.add(iCache2);
                continue;
            }
            if (!iCache2.isConsistent(dataSchema)) {
                m_Log.debug((Object)("Removing cache with inconsistent schema: " + String.valueOf(iCache2)));
                arrayList.add(iCache2);
                continue;
            }
            if (!iCache2.isConsistent(string2)) continue;
            m_Log.debug((Object)("Cache found: " + String.valueOf(iCache2)));
            iCache = iCache2;
        }
        list.removeAll(arrayList);
        return iCache;
    }

    @Override
    public synchronized void addCache(ICache iCache) {
        m_Log.debug((Object)("Adding cache: " + String.valueOf(iCache)));
        String string = iCache.getCachePath();
        List<ICache> list = this.m_CacheMap.get(string);
        if (list == null) {
            list = new ArrayList<ICache>();
            this.m_CacheMap.put(string, list);
        }
        list.add(iCache);
    }

    @Override
    public synchronized void removeCache(ICache iCache) {
        m_Log.debug((Object)("Removing cache: " + String.valueOf(iCache)));
        String string = iCache.getCachePath();
        List<ICache> list = this.m_CacheMap.get(string);
        if (list != null) {
            list.remove(iCache);
        }
    }

    @Override
    public synchronized void removeExpired() {
        m_Log.debug((Object)"Starting regular scan for expired caches");
        RMLRepository rMLRepository = (RMLRepository)Elixir.get(RMLRepository.class);
        ArrayList<ICache> arrayList = new ArrayList<ICache>();
        for (List<ICache> list : this.m_CacheMap.values()) {
            for (ICache iCache : list) {
                if (iCache.hasExpired()) {
                    m_Log.debug((Object)("Removing expired cache: " + String.valueOf(iCache)));
                    arrayList.add(iCache);
                    continue;
                }
                String string = iCache.getCachePath();
                RMLFileObject rMLFileObject = rMLRepository.getFileJ(string);
                if (rMLFileObject != null) continue;
                m_Log.debug((Object)("Removing deleted cache: " + String.valueOf(iCache)));
                arrayList.add(iCache);
            }
            list.removeAll(arrayList);
            arrayList.clear();
        }
        m_Log.debug((Object)"Regular scan completed");
    }

    @Override
    public void run() {
        while (true) {
            this.removeExpired();
            try {
                CacheManager.sleep(this.m_ExpiryInterval);
                continue;
            }
            catch (InterruptedException interruptedException) {
                m_Log.warn((Object)"sleep interrupted");
                continue;
            }
            break;
        }
    }
}

