/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.codec;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.datasource.composite.DataStoreCodec;
import com.elixirtech.jdom.Element;

public class XLSXCodec
implements DataStoreCodec {
    @Override
    public DataStore buildDataStore(Element element) {
        DataStore dataStore = new DataStore("Excel File");
        Element element2 = element.getChild("xlsx", Data2Constants.NS_DATASOURCE);
        if (element2 != null) {
            dataStore.setProperty("XLSX_URL", element2.getAttributeValue("url"));
            dataStore.setProperty("XLSX_SheetGroupLevel", element2.getAttributeValue("sheet-group-level"));
            dataStore.setProperty("XLSX_FirstRowHeader", element2.getAttributeValue("first-row-header"));
            dataStore.setProperty("XLSX_SheetName", element2.getAttributeValue("sheet-name"));
            dataStore.setProperty("XLSX_Password", element2.getAttributeValue("password"));
        }
        return dataStore;
    }

    @Override
    public Element buildElement(Node node) {
        Element element = new Element("xlsx", Data2Constants.NS_DATASOURCE);
        element.setAttribute("url", node.getUserProperty("XLSX_URL"));
        element.setAttribute("sheet-group-level", this.notNull(node.getUserProperty("XLSX_SheetGroupLevel")));
        element.setAttribute("first-row-header", this.notNull(node.getUserProperty("XLSX_FirstRowHeader")));
        element.setAttribute("sheet-name", this.notNull(node.getUserProperty("XLSX_SheetName")));
        element.setAttribute("password", this.notNull(node.getUserProperty("XLSX_Password")));
        return element;
    }

    private String notNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

