/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.composite;

import com.elixirtech.arch.IAdaptable;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.datasource.composite.DataStoreRegistry;
import com.elixirtech.data2.datasource.discard.DiscardDataSource;
import com.elixirtech.data2.output.IDataStore;
import com.elixirtech.data2.output.IDataStore2;
import com.elixirtech.ensemble.ds.RecordCounter;
import java.util.List;
import java.util.Set;

public class DataDropDataSource
implements IDataSource {
    private final String m_Name;
    private final IDataSource m_DataSource;
    private final DataStore m_DataStore;
    private final Set<String> m_DiscardSet;
    private final List<String> m_OrderList;

    public DataDropDataSource(String string, IDataSource iDataSource, DataStore dataStore, Set<String> set, List<String> list) {
        this.m_Name = string;
        this.m_DataSource = iDataSource;
        this.m_DataStore = dataStore;
        this.m_DiscardSet = set;
        this.m_OrderList = list;
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        if (clazz == IDataSource.class) {
            return clazz.cast(this);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getDescription() {
        return this.m_DataSource.getDescription();
    }

    @Override
    public String getType() {
        return "DataDrop";
    }

    @Override
    public List<Parameter> getParameters() {
        return this.m_DataSource.getParameters();
    }

    @Override
    public DataSchema getSchema() {
        DataSchema dataSchema = this.m_DataSource.getSchema();
        if (this.m_DiscardSet.isEmpty() && this.m_OrderList.isEmpty()) {
            return dataSchema;
        }
        SchemaBuilder schemaBuilder = new SchemaBuilder(dataSchema);
        schemaBuilder.discard(this.m_DiscardSet);
        schemaBuilder.order(this.m_OrderList);
        return schemaBuilder.getSchema();
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        DL dL = new DL(pushContext, dataListener);
        if (this.m_DiscardSet.isEmpty() && this.m_OrderList.isEmpty()) {
            this.m_DataSource.pushTo(pushContext, dL);
        } else {
            this.m_DataSource.pushTo(pushContext, new DiscardDataSource.Discarder(this, this.m_DiscardSet, this.m_OrderList, dL));
        }
    }

    private class DL
    implements DataListener2 {
        private DataListener m_DataListener;
        private DataListener m_StoreListener;

        public DL(PushContext pushContext, DataListener dataListener) {
            DataListener2 dataListener2;
            this.m_DataListener = dataListener;
            this.m_StoreListener = DataStoreRegistry.getDataListener(pushContext, DataDropDataSource.this.m_DataStore);
            if (dataListener == this.m_StoreListener) {
                this.m_StoreListener = null;
            } else if (dataListener instanceof RecordCounter && (dataListener2 = ((RecordCounter)dataListener).getNextListener()) instanceof IDataStore2 && this.m_StoreListener instanceof IDataStore2) {
                IDataStore2 iDataStore2 = (IDataStore2)this.m_StoreListener;
                IDataStore2 iDataStore22 = (IDataStore2)dataListener2;
                if (iDataStore2.getDataStore() == iDataStore22.getDataStore()) {
                    this.m_StoreListener = null;
                }
            }
            if (this.m_StoreListener instanceof IDataStore) {
                dataListener2 = (IDataStore)this.m_StoreListener;
                dataListener2.setContext(pushContext);
                dataListener2.setName(DataDropDataSource.this.m_DataStore.getName());
            }
        }

        @Override
        public void startData(IDataSource iDataSource) {
            if (this.m_StoreListener != null) {
                this.m_StoreListener.startData(DataDropDataSource.this);
            }
            if (this.m_DataListener != null) {
                this.m_DataListener.startData(DataDropDataSource.this);
            }
        }

        @Override
        public void startGroup(DataGroup dataGroup) {
            if (this.m_StoreListener != null) {
                this.m_StoreListener.startGroup(dataGroup);
            }
            if (this.m_DataListener != null) {
                this.m_DataListener.startGroup(dataGroup);
            }
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            boolean bl = true;
            if (this.m_StoreListener != null) {
                boolean bl2 = bl = this.m_StoreListener.processRecord(dataRecord) && bl;
            }
            if (this.m_DataListener != null) {
                bl = this.m_DataListener.processRecord(dataRecord) && bl;
            }
            return bl;
        }

        @Override
        public void endGroup(DataGroup dataGroup) {
            if (this.m_StoreListener != null) {
                this.m_StoreListener.endGroup(dataGroup);
            }
            if (this.m_DataListener != null) {
                this.m_DataListener.endGroup(dataGroup);
            }
        }

        @Override
        public void endData(IDataSource iDataSource) {
            if (this.m_StoreListener != null) {
                this.m_StoreListener.endData(DataDropDataSource.this);
            }
            if (this.m_DataListener != null) {
                this.m_DataListener.endData(DataDropDataSource.this);
            }
        }

        @Override
        public <T> T getAdapter(Class<T> clazz) {
            if (clazz == IDataSource.class) {
                return clazz.cast(DataDropDataSource.this);
            }
            return null;
        }
    }
}

