/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.composite;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.composite.SubFlowDataSource;
import com.elixirtech.jdom.Element;

public class SubFlowDefinition
extends DataSourceDefinition {
    public static final String SUBFLOW = "subflow";
    public static final String OUTPUT = "output";

    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild(SUBFLOW, NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load subflow element");
        }
        SubFlowDataSource subFlowDataSource = new SubFlowDataSource();
        subFlowDataSource.setName(string);
        String string2 = element2.getAttributeValue("parent");
        String string3 = element2.getAttributeValue(OUTPUT);
        IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string2);
        subFlowDataSource.setParent(iDataSource);
        IDataSource iDataSource2 = dataSourceManager.getDataSource(dataSourceManager, string3);
        subFlowDataSource.setOutput(iDataSource2);
        return subFlowDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof SubFlowDataSource)) {
            throw new IllegalArgumentException("Not a SubFlowDataSource");
        }
        SubFlowDataSource subFlowDataSource = (SubFlowDataSource)iDataSource;
        Element element = this.defineDataSource(subFlowDataSource);
        Element element2 = new Element(SUBFLOW, NS_DATASOURCE);
        element2.setAttribute("parent", subFlowDataSource.getParent().getName());
        element2.setAttribute(OUTPUT, subFlowDataSource.getOutput().getName());
        element.addContent(element2);
        return element;
    }
}

