/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.concat;

import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ConcatDataSource
extends AbstractDataSource {
    public static final String TYPE_UNION = "Union";
    public static final String TYPE_INTERSECTION = "Intersection";
    private String m_Name;
    private String m_Description;
    private String m_ConcatType = "Union";
    private DataSchema m_Schema;
    private boolean m_PushStarted;
    List<IDataSource> m_Sources = new ArrayList<IDataSource>();

    public void setName(String string) {
        this.m_Name = string;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public void setDescription(String string) {
        this.m_Description = string;
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    @Override
    public String getType() {
        return "Concat";
    }

    public void setConcatType(String string) {
        this.m_ConcatType = string;
    }

    public String getConcatType() {
        return this.m_ConcatType;
    }

    @Override
    public DataSchema getSchema() {
        if (this.m_Schema == null) {
            this.buildSchema();
        }
        return this.m_Schema;
    }

    public void addDataSource(IDataSource iDataSource) {
        assert (!this.m_PushStarted) : "can't add datasource after push started";
        assert (iDataSource != null);
        this.m_Sources.add(iDataSource);
        this.m_Schema = null;
    }

    public List<IDataSource> getDataSources() {
        return Collections.unmodifiableList(this.m_Sources);
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        this.m_PushStarted = true;
        new ConcatListener(pushContext, dataListener);
    }

    protected void buildSchema() {
        if (this.m_Sources.size() > 0) {
            Iterator<IDataSource> iterator = this.m_Sources.iterator();
            IDataSource iDataSource = iterator.next();
            DataSchema dataSchema = iDataSource.getSchema();
            SchemaBuilder schemaBuilder = new SchemaBuilder(dataSchema);
            while (iterator.hasNext()) {
                iDataSource = iterator.next();
                dataSchema = iDataSource.getSchema();
                if (TYPE_INTERSECTION.equals(this.m_ConcatType)) {
                    schemaBuilder.intersect(dataSchema);
                    continue;
                }
                schemaBuilder.union(dataSchema);
            }
            this.m_Schema = schemaBuilder.getSchema();
        }
    }

    protected DataRecord adjustRecord(DataRecord dataRecord) {
        assert (dataRecord != null) : "record is null";
        assert (this.m_Schema != null) : "m_Schema is null";
        DataSchema dataSchema = dataRecord.getSchema();
        if (dataSchema.equals(this.m_Schema)) {
            return dataRecord;
        }
        int n = this.m_Schema.getColumnCount();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            String string = this.m_Schema.getColumnName(i);
            int n2 = dataSchema.getColumnIndex(string);
            if (n2 >= 0) {
                DataType dataType = this.m_Schema.getColumnType(i);
                Object object = dataRecord.getData(n2);
                DataType dataType2 = dataSchema.getColumnType(n2);
                if (dataType2 == dataType) {
                    objectArray[i] = object;
                    continue;
                }
                objectArray[i] = this.m_Schema.narrow(dataType, object);
                continue;
            }
            objectArray[i] = null;
        }
        return new DataRecord(this.m_Schema, objectArray);
    }

    private class ConcatListener
    implements DataListener2 {
        private final PushContext m_PushContext;
        private final DataListener m_Listener;
        private DataGroup m_Group;
        private int m_SourceIdx;

        public ConcatListener(PushContext pushContext, DataListener dataListener) {
            this.m_PushContext = pushContext;
            this.m_Listener = dataListener;
            this.m_SourceIdx = ConcatDataSource.this.m_Sources.size() - 1;
            IDataSource iDataSource = ConcatDataSource.this.m_Sources.get(this.m_SourceIdx);
            iDataSource.pushTo(this.m_PushContext, this);
            this.m_Listener.endData(ConcatDataSource.this);
        }

        @Override
        public <T> T getAdapter(Class<T> clazz) {
            if (clazz == IDataSource.class) {
                return clazz.cast(ConcatDataSource.this);
            }
            return null;
        }

        @Override
        public void startData(IDataSource iDataSource) {
            Object object;
            if (this.m_SourceIdx > 0) {
                --this.m_SourceIdx;
                object = ConcatDataSource.this.m_Sources.get(this.m_SourceIdx);
                object.pushTo(this.m_PushContext, this);
            } else {
                ConcatDataSource.this.buildSchema();
                this.m_Listener.startData(ConcatDataSource.this);
            }
            if (ConcatDataSource.this.m_Schema == null && this.m_SourceIdx == 0) {
                ConcatDataSource.this.buildSchema();
            }
            if ((object = iDataSource.getName()) == null) {
                object = "";
            }
            this.m_Group = new DataGroup(1, (String)object);
            this.m_Listener.startGroup(this.m_Group);
            assert (ConcatDataSource.this.m_Schema != null) : "m_Schema is null";
        }

        @Override
        public void startGroup(DataGroup dataGroup) {
            ConcatDataGroup concatDataGroup = new ConcatDataGroup(dataGroup);
            this.m_Listener.startGroup(concatDataGroup);
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            DataRecord dataRecord2 = ConcatDataSource.this.adjustRecord(dataRecord);
            return this.m_Listener.processRecord(dataRecord2);
        }

        @Override
        public void endGroup(DataGroup dataGroup) {
            ConcatDataGroup concatDataGroup = new ConcatDataGroup(dataGroup);
            this.m_Listener.endGroup(concatDataGroup);
        }

        @Override
        public void endData(IDataSource iDataSource) {
            this.m_Listener.endGroup(this.m_Group);
            this.m_Group = null;
        }
    }

    public static class ConcatDataGroup
    extends DataGroup {
        private final DataGroup m_Original;

        public ConcatDataGroup(DataGroup dataGroup) {
            super(dataGroup.getLevel() + 1, dataGroup.getName());
            this.m_Original = dataGroup;
        }

        public DataGroup getOriginalGroup() {
            return this.m_Original;
        }
    }
}

