/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.dataset;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.dataset.DatasetDataSource;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Namespace;

public class DatasetDefinition
extends DataSourceDefinition {
    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        Namespace namespace = element.getNamespace();
        if (namespace == null) {
            throw new IllegalArgumentException("Got null namespace for " + String.valueOf(element));
        }
        if (!"datasource".equals(element.getName())) {
            throw new IllegalArgumentException("Expected datasource, got " + element.getName());
        }
        if (!namespace.equals(NS_DATASOURCE)) {
            throw new IllegalArgumentException("Element " + element.getName() + " with namespace " + namespace.toString() + " is not a ds:datasource");
        }
        Element element2 = element.getChild("schema", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load schema");
        }
        DataSchema dataSchema = DatasetDefinition.loadSchema(element2);
        Element element3 = element.getChild("dataset", NS_DATASOURCE);
        if (element3 == null) {
            throw new DataException("Can't load dataset element");
        }
        DatasetDataSource datasetDataSource = new DatasetDataSource();
        datasetDataSource.setName(element.getAttributeValue("name"));
        datasetDataSource.setSchema(dataSchema);
        datasetDataSource.setDescription(element.getAttributeValue("description"));
        datasetDataSource.setDataset(element3.getAttributeValue("dataset"));
        datasetDataSource.setInParameters(element3.getAttributeValue("in-parameters"));
        datasetDataSource.setSecurity(this.loadSecurity(element));
        return datasetDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof DatasetDataSource)) {
            throw new IllegalArgumentException("Not a DatasetDataSource");
        }
        DatasetDataSource datasetDataSource = (DatasetDataSource)iDataSource;
        Element element = this.defineDataSource(datasetDataSource);
        DatasetDefinition.saveSchema(datasetDataSource.getSchema(), element);
        Element element2 = new Element("dataset", NS_DATASOURCE);
        DatasetDefinition.setAttribute(element2, "dataset", datasetDataSource.getDataset());
        DatasetDefinition.setAttribute(element2, "in-parameters", datasetDataSource.getInParameters());
        element.addContent(element2);
        this.saveSecurity(datasetDataSource.getSecurity(), element);
        return element;
    }
}

