/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.derivative;

import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.SchemaItem;
import com.elixirtech.data2.datasource.derivative.Derivative;
import com.elixirtech.data2.datasource.derivative.DerivativeContext;
import com.elixirtech.data2.datasource.derivative.DerivedDataSource;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractTransformer
implements DataListener2 {
    protected final DerivedDataSource m_DataSource;
    protected final PushContext m_Context;
    protected final DataListener m_DataListener;
    protected List<DerivativeContext> m_Derivatives = new ArrayList<DerivativeContext>();
    protected int m_ColumnCount;
    protected DataSchema m_ParentSchema;
    protected DataSchema m_Schema;
    protected int[] m_ParentLookup;
    protected boolean m_InOrderLookup;

    public AbstractTransformer(DerivedDataSource derivedDataSource, PushContext pushContext, DataListener dataListener) {
        this.m_DataSource = derivedDataSource;
        this.m_Context = pushContext;
        this.m_DataListener = dataListener;
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IDataSource.class) {
            return clazz.cast(this.m_DataSource);
        }
        return null;
    }

    @Override
    public void startData(IDataSource iDataSource) {
        this.m_Derivatives.clear();
        for (Derivative object : this.m_DataSource.m_Derivatives) {
            this.m_Derivatives.add(object.init(this.m_Context));
        }
        DataSchema dataSchema = iDataSource.getSchema();
        this.m_Schema = this.buildSchema();
        this.m_ColumnCount = this.m_Schema.getColumnCount();
        this.m_DataListener.startData(this.m_DataSource);
        for (DerivativeContext derivativeContext : this.m_Derivatives) {
            derivativeContext.startData(this.m_Context, dataSchema, this.m_Schema);
        }
    }

    @Override
    public void startGroup(DataGroup dataGroup) {
        this.m_DataListener.startGroup(dataGroup);
    }

    @Override
    public abstract boolean processRecord(DataRecord var1);

    @Override
    public void endGroup(DataGroup dataGroup) {
        this.m_DataListener.endGroup(dataGroup);
    }

    @Override
    public void endData(IDataSource iDataSource) {
        for (DerivativeContext derivativeContext : this.m_Derivatives) {
            derivativeContext.endData();
        }
        this.m_DataListener.endData(this.m_DataSource);
        this.m_Derivatives.clear();
    }

    protected DataSchema buildSchema() {
        int n;
        this.m_ParentSchema = this.m_DataSource.m_Parent.getSchema();
        if (this.m_Derivatives.size() == 0) {
            return this.m_ParentSchema;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        SchemaBuilder schemaBuilder = new SchemaBuilder(this.m_ParentSchema.isCaseSensitive());
        int n3 = this.m_ParentSchema.getColumnCount();
        for (n = 0; n < n3; ++n) {
            String object = this.m_ParentSchema.getColumnName(n);
            DataType dataType = this.m_ParentSchema.getColumnType(n);
            DataAttributes dataAttributes = this.m_ParentSchema.getAttributes(n);
            if (!this.m_DataSource.m_DiscardSet.contains(object)) {
                schemaBuilder.add(this.m_DataSource.m_Prefix.apply(object), dataType, dataAttributes);
                arrayList.add(new Integer(n2));
            }
            ++n2;
        }
        this.m_ParentLookup = new int[arrayList.size()];
        this.m_InOrderLookup = true;
        for (n = 0; n < this.m_ParentLookup.length; ++n) {
            this.m_ParentLookup[n] = (Integer)arrayList.get(n);
            this.m_InOrderLookup &= this.m_ParentLookup[n] == n;
        }
        for (Derivative derivative : this.m_DataSource.m_Derivatives) {
            int n4 = derivative.getColumnCount();
            for (int i = 0; i < n4; ++i) {
                String string = derivative.getColumnName(i);
                DataType dataType = derivative.getColumnType(i);
                SchemaItem schemaItem = new SchemaItem(string, dataType);
                schemaBuilder.add(schemaItem);
            }
        }
        return schemaBuilder.getSchema();
    }
}

