/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.derivative;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.datasource.derivative.CrossJoinDerivativeContext;
import com.elixirtech.data2.datasource.derivative.Derivative;
import com.elixirtech.data2.datasource.derivative.DerivativeContext;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class CrossJoinDerivative
implements Derivative {
    public static final String EMPTY_PREFIX = "";
    protected final IDataSource m_SecondarySource;
    protected final DataSchema m_SecondarySchema;
    protected DataSchema m_OutputSchema;
    protected String m_Prefix = "";
    protected Set<String> m_DiscardSet = Collections.emptySet();

    public CrossJoinDerivative(IDataSource iDataSource) {
        this.m_SecondarySource = iDataSource;
        this.m_OutputSchema = this.m_SecondarySchema = this.m_SecondarySource.getSchema();
    }

    @Override
    public DerivativeContext init(PushContext pushContext) {
        return new CrossJoinDerivativeContext(this);
    }

    @Override
    public void getParameters(ArgumentMap argumentMap) {
        List<Parameter> list = this.m_SecondarySource.getParameters();
        argumentMap.addParameters(list);
    }

    public void setDiscardSet(Set<String> set) {
        this.m_DiscardSet = set;
        SchemaBuilder schemaBuilder = new SchemaBuilder(this.m_SecondarySchema);
        schemaBuilder.discard(set);
        this.m_OutputSchema = schemaBuilder.getSchema();
    }

    public Set<String> getDiscardSet() {
        return this.m_DiscardSet;
    }

    public void setPrefix(String string) {
        this.m_Prefix = StringUtil.isEmpty(string) ? EMPTY_PREFIX : string;
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String getSecondaryName() {
        return this.m_SecondarySource.getName();
    }

    @Override
    public int getColumnCount() {
        return this.m_OutputSchema.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        String string = this.m_OutputSchema.getColumnName(n);
        if (this.m_Prefix == EMPTY_PREFIX) {
            return string;
        }
        return this.m_Prefix + this.m_OutputSchema.getColumnName(n);
    }

    @Override
    public DataType getColumnType(int n) {
        return this.m_OutputSchema.getColumnType(n);
    }
}

