/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.discard;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.discard.DiscardDataSource;
import com.elixirtech.jdom.Element;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DiscardDefinition
extends DataSourceDefinition {
    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild("discard", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load discard element");
        }
        String string2 = element2.getAttributeValue("parent");
        IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string2);
        DiscardDataSource discardDataSource = new DiscardDataSource(string, iDataSource);
        HashSet<String> hashSet = new HashSet<String>();
        for (Element element3 : element2.getChildren("item", NS_DATASOURCE)) {
            hashSet.add(element3.getAttributeValue("name"));
        }
        discardDataSource.setDiscardSet(hashSet);
        return discardDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof DiscardDataSource)) {
            throw new IllegalArgumentException("Not a DiscardDataSource");
        }
        DiscardDataSource discardDataSource = (DiscardDataSource)iDataSource;
        Element element = this.defineDataSource(discardDataSource);
        Element element2 = new Element("discard", NS_DATASOURCE);
        element2.setAttribute("parent", discardDataSource.getParent().getName());
        Set<String> set = discardDataSource.getDiscardSet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            Element element3 = new Element("item", NS_DATASOURCE);
            element3.setAttribute("name", iterator.next());
            element2.addContent(element3);
        }
        element.addContent(element2);
        return element;
    }
}

