/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.excel;

import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.FileBasedDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.excel.IExcelProcessor;
import com.elixirtech.data2.datasource.excel.XProcessor;
import java.util.List;

public class ExcelDataSource
extends FileBasedDataSource {
    private static boolean initDone = false;
    public static final String TYPE = "Excel";
    private String m_Name;
    private String m_Description;
    private DataSchema m_Schema;
    private String m_URL;
    private String m_Range = "=";
    private int m_HeaderRow;
    private boolean m_XLSX;

    public ExcelDataSource() {
        this("", new DataSchema());
    }

    public ExcelDataSource(String string, DataSchema dataSchema) {
        this.m_Name = string;
        this.m_Schema = dataSchema;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getURL() {
        return this.m_URL;
    }

    public String getRange() {
        return this.m_Range;
    }

    public int getHeaderRow() {
        return this.m_HeaderRow;
    }

    public void setHeaderRow(int n) {
        if (n != this.m_HeaderRow) {
            this.m_HeaderRow = n;
            this.setDirty(true);
        }
    }

    public void setName(String string) {
        if (ExcelDataSource.changed(this.m_Name, string)) {
            this.m_Name = string;
            this.setDirty(true);
        }
    }

    public void setDescription(String string) {
        if (ExcelDataSource.changed(this.m_Description, string)) {
            this.m_Description = string;
            this.setDirty(true);
        }
    }

    public void setURL(String string) {
        if (ExcelDataSource.changed(this.m_URL, string)) {
            this.m_URL = string;
            this.setDirty(true);
        }
    }

    public void setRange(String string) {
        if (ExcelDataSource.changed(this.m_Range, string)) {
            this.m_Range = string;
            this.setDirty(true);
        }
    }

    public void setXLSX(boolean bl) {
        if (ExcelDataSource.changed(this.m_XLSX, bl)) {
            this.m_XLSX = bl;
            this.setDirty(true);
        }
    }

    public boolean isXLSX() {
        return this.m_XLSX;
    }

    public void setSchema(DataSchema dataSchema) {
        if (ExcelDataSource.changed(this.m_Schema, dataSchema)) {
            this.m_Schema = dataSchema;
            this.setDirty(true);
        }
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        argumentMap.extractParameters(this.m_URL);
        argumentMap.extractParameters(this.m_Range);
        return argumentMap.getParameters();
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Schema;
    }

    protected IExcelProcessor getExcelProcessor(PushContext pushContext) {
        return new XProcessor(this);
    }

    public void inferSchema(PushContext pushContext) {
        DataSchema dataSchema = this.getExcelProcessor(pushContext).inferSchema(pushContext);
        if (dataSchema != null) {
            this.m_Schema = dataSchema;
        }
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        this.getExcelProcessor(pushContext).pushTo(pushContext, dataListener);
    }
}

